#ifndef kVS_XML_UTILS_X_H
#define kVS_XML_UTILS_X_H

#include <kApi/Data/kXml.h>
#include <kApi/Data/kMap.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Io/kPath.h>
#include <kVision/Common/kVsLog.h>

#define kVS_XML_UTILS_SYNTAX_INCLUDE_TAG                "include"
#define kVS_XML_UTILS_SYNTAX_INCLUDE_PATH_ATTR          "href"
#define kVS_XML_UTILS_SYNTAX_FILTER_TAG                 "_"
#define kVS_XML_UTILS_ATTRIBUTE_MAX                     (256)

kStatus kVsXmlUtils_MergeBranches(kXml xml, kXmlItem childBranch, kXmlItem siblingBranch);
kMap kVsXmlUtil_ChooseMoreSpecificFilter(kMap a, kMap b);
kStatus kVsXmlUtils_MergeLeaves(kXml xml, kXmlItem childLeaf, kXmlItem siblingLeaf, kXmlItem* theChosenOne);
kStatus kVsXmlUtils_SiblingMergeable(kXml xml, kXmlItem child, kXmlItem sibling, kBool* mergeable);
kStatus kVsXmlUtils_MergeRecursive(kXml xml, kXmlItem item);
kBool kVsXmlUtils_DoStringsMatch(kString a, kString b, kChar* wildcard);
kStatus kVsXmlUtils_ExtractNodeFilter(kXml xml, kXmlItem node, kMap* filter);
kStatus kVsXmlUtils_FilterNode(kXml xml, kXmlItem node, kMap filter, kBool* pass, kBool strict);
kStatus kVsXmlUtils_FilterRecursive(kXml xml, kXmlItem node, kMap filter, kBool strict);
kStatus kVsXmlUtils_ProcessIncludesRecursive(kXml xml, kXmlItem node, const kChar* xmlFilePath);
kStatus kVsXmlUtils_PropagateFilterAttrs(kXml xml, kXmlItem node);

kStatus kVsXmlUtils_CleanElementTagsRecursive(kXml *xml, kXmlItem item);
kStatus kVsXmlUtils_CleanAttributeTagsRecursive(kXml xml, kXmlItem node);

kStatus kVsXmlUtils_ResolveMacrosRecursive(kXml xml, kXmlItem node, kMap fieldValues);
kStatus kVsXmlUtils_FindMacrosRecursive(kXml xml, kXmlItem node);
kStatus kVsXmlUtils_XmlAddToMapRecursive(kXml xml, kXmlItem parent, kXmlItem item, kMap map);

#endif  /* #ifndef kVS_XML_UTILS_X_H */
