
#ifndef LMITECH_KVISION_STORAGE_INPUT_BLOCK_X_H_INCLUDED
#define LMITECH_KVISION_STORAGE_INPUT_BLOCK_X_H_INCLUDED

#include <kVision/Vs/kVsStorageInputBlockInfo.h>
#include <kVision/Vs/kVsStorageInputBlock.h>
#include <kFireSync/Data/kMsg.h>
#include <kFireSync/Pipe/kPxPort.h>
#include <kApi/Io/kFile.h>
#include <kApi/Io/kPath.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kImage.h>

#define kVS_STORAGE_INPUT_BLOCK_DESCRIPTION             "Loading file from Storage Block"
#define kVS_STORAGE_INPUT_DEFAULT_INPUT_FILENAME      "InputFile.kdat"

typedef struct kVsStorageInputBlockClass 
{
    kPxBlockClass base;
    kVsStorageInputBlockInfo settings;

    kPort inputPort;      //input port serves as a trigger. Any incoming data is ignored.

    kPort outputPort;    //output "camera0" port

    kArrayList inputArray;    //stored images to be emitted for camera 0

    kSize outputCount; //Number of items already sent to output port
} kVsStorageInputBlockClass;

kDeclareClassEx(kVs, kVsStorageInputBlock, kPxBlock)
kVsFx(const kChar*) kVsStorageInputBlock_VDescription();
kVsFx(kStatus) kVsStorageInputBlock_VOnSetup(kVsStorageInputBlock block);
kVsFx(kStatus) kVsStorageInputBlock_VOnStart(kVsStorageInputBlock block);
kVsFx(kStatus) kVsStorageInputBlock_VOnPause(kVsStorageInputBlock block);
kVsFx(kStatus) kVsStorageInputBlock_VOnResume(kVsStorageInputBlock block);
kVsFx(kStatus) kVsStorageInputBlock_VOnStop(kVsStorageInputBlock block);
kVsFx(kStatus) kVsStorageInputBlock_VOnReceive(kVsStorageInputBlock block, kPxPort port, kMsgSet msg);

kStatus kVsStorageInputBlock_ConfigureDefaults(kVsStorageInputBlockInfo info);
kStatus kVsStorageInputBlock_Validate(kVsStorageInputBlockInfo info);

kStatus kVsStorageInputBlock_LoadInputData(kVsStorageInputBlock block,kVsStorageInputBlockInfo info);
kStatus kVsStorageInputBlock_SetOutputCount(kVsStorageInputBlock block, kSize outputCount);

#endif
