#ifndef LMITECH_KVISION_VS_PRNUBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_VS_PRNUBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

#define kVS_PRNU_BLOCK_NAME                  "3D_PRNU"
#define kVS_PRNU_BLOCK_TYPE_NAME             "kVsPrnuBlock"

#define kVS_PRNU_BLOCK_INIMAGE_NAME          "InImage"
#define kVS_PRNU_BLOCK_OUTIMAGE_NAME         "OutImage"

typedef enum
{
    kVS_PRNU_BLOCK_INIMAGE_BEGIN   = 0,
    kVS_PRNU_BLOCK_OUTIMAGE_BEGIN  = 100
} PrnuBlockPort;

typedef kPointer kVsPrnuBlockInfo;

kVsFx(kStatus) kVsPrnuBlockInfo_Construct(kVsPrnuBlockInfo* info);
kVsFx(kStatus) kVsPrnuBlockInfo_Load(kVsPrnuBlockInfo* info, kXml xml);
kVsFx(kStatus) kVsPrnuBlockInfo_Destroy(kVsPrnuBlockInfo info);
kVsFx(kStatus) kVsPrnuBlockInfo_Store(kVsPrnuBlockInfo info, kXml* xml);

kVsFx(kStatus) kVsPrnuBlockInfo_Read(kVsPrnuBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kVsPrnuBlockInfo_Write(kVsPrnuBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kVsPrnuBlockInfo_SetRunWindow(kVsPrnuBlockInfo info, const kL3dCameraWindow* window);
kVsFx(kStatus) kVsPrnuBlockInfo_SetCalFileName(kVsPrnuBlockInfo info, const kChar* fileName);
kVsFx(kStatus) kVsPrnuBlockInfo_SetCameraIndex(kVsPrnuBlockInfo info, k32u cameraIndex);
kVsFx(kStatus) kVsPrnuBlockInfo_SetStateCount(kVsPrnuBlockInfo info, k32u stateCount);
kVsFx(kStatus) kVsPrnuBlockInfo_SetExposure(kVsPrnuBlockInfo info, k32u exposure);

kVsFx(const kL3dCameraWindow*) kVsPrnuBlockInfo_RunWindow(kVsPrnuBlockInfo info);
kVsFx(const kChar*) kVsPrnuBlockInfo_CalFileName(kVsPrnuBlockInfo info);
kVsFx(k32u) kVsPrnuBlockInfo_CameraIndex(kVsPrnuBlockInfo info);
kVsFx(k32u) kVsPrnuBlockInfo_StateCount(kVsPrnuBlockInfo info);
kVsFx(k32u) kVsPrnuBlockInfo_Exposure(kVsPrnuBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_VS_PRNUBLOCKINFO_H_INCLUDED  */
