/** 
 * @file    kVsPrnuActionInfo.x.h
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_VS_PRNU_ACTION_INFO_X_H_INCLUDED
#define LMITECH_KVISION_VS_PRNU_ACTION_INFO_X_H_INCLUDED

#include <kVision/Vs/kVsPrnuCal.h>

typedef struct kVsPrnuActionInfoClass
{
    kObjectClass base; 

    kL3dCameraWindow runWindow;
    kText256 calFileName;
    k32u stateCount;
    k32u exposure;
    k32u viewIndex;

} kVsPrnuActionInfoClass; 

kDeclareClassEx(kVs, kVsPrnuActionInfo, kObject)

kVsFx(kStatus) kVsPrnuActionInfo_Init(kVsPrnuActionInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kVsPrnuActionInfo_VRelease(kVsPrnuActionInfo info);

#endif
