/** 
 * @file    kVsPrnuActionInfo.h
 * @brief   Declares the kVsPrnuActionInfo class. 
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_VS_PRNU_ACTION_INFO_H_INCLUDED
#define LMITECH_KVISION_VS_PRNU_ACTION_INFO_H_INCLUDED

#include <kVision/Common/kVision.h>
#include <kApi/Data/kXml.h>
#include <kVision/L3d/kL3dTransform2d.h>

/**
 * @class   kVsPrnuActionInfo
 * @ingroup kVision
 * @brief   Settings for kVsPrnuAction.
 */
typedef kObject kVsPrnuActionInfo; 

kVsFx(kStatus) kVsPrnuActionInfo_Construct(kVsPrnuActionInfo* info, kAlloc allocator);
kVsFx(kStatus) kVsPrnuActionInfo_Load(kVsPrnuActionInfo* info, kXml xml, kAlloc allocator);
kVsFx(kStatus) kVsPrnuActionInfo_Store(kVsPrnuActionInfo info, kXml* xml, kAlloc allocator);

kVsFx(kStatus) kVsPrnuActionInfo_Read(kVsPrnuActionInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kVsPrnuActionInfo_Write(kVsPrnuActionInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kVsPrnuActionInfo_Clear(kVsPrnuActionInfo info);
kVsFx(kStatus) kVsPrnuActionInfo_Validate(kVsPrnuActionInfo info);

kVsFx(kStatus) kVsPrnuActionInfo_SetRunWindow(kVsPrnuActionInfo info, const kL3dCameraWindow* window);
kVsFx(kStatus) kVsPrnuActionInfo_SetCalFileName(kVsPrnuActionInfo info, const kChar* fileName);
kVsFx(kStatus) kVsPrnuActionInfo_SetExposure(kVsPrnuActionInfo info, k32u exposure);
kVsFx(kStatus) kVsPrnuActionInfo_SetViewIndex(kVsPrnuActionInfo info, k32u index);

kVsFx(const kL3dCameraWindow*) kVsPrnuActionInfo_RunWindow(kVsPrnuActionInfo info);
kVsFx(const kChar*) kVsPrnuActionInfo_CalFileName(kVsPrnuActionInfo info);
kVsFx(k32u) kVsPrnuActionInfo_Exposure(kVsPrnuActionInfo info);
kVsFx(k32u) kVsPrnuActionInfo_ViewIndex(kVsPrnuActionInfo info);

#include <kVision/Vs/kVsPrnuActionInfo.x.h>

#endif
