#ifndef kVS_ANALOG_ADJUST_ACTION_OUTPUT_H
#define kVS_ANALOG_ADJUST_ACTION_OUTPUT_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Action/kAxAction.h>
#include <kApi/Data/kXml.h>

typedef enum
{
    kVS_ANALOG_ADJUST_ACTION_OUTPUT_NONE = 0,
    kVS_ANALOG_ADJUST_ACTION_OUTPUT_DENSE_LUT = 1,
    kVS_ANALOG_ADJUST_ACTION_OUTPUT_LINEAR = 2
    
} kVsAnalogAdjustActionOutputCorrectionMethod;

/**
* @class       kVsAnalogAdjustActionOutput
* @extends     kObject
* @ingroup     kVision-Vs
* @brief       Class object for the kVsAnalogAdjustActionOutput class.
*/
typedef kObject kVsAnalogAdjustActionOutput;


/**
* Constructs a kVsAnalogAdjustActionOutput object.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object       Destination for the constructed object handle.
* @param   sensor       The sensor being calibrated.
* @param   sensorId     The sensor SN - Only used for saving.  For loading the value is not used.
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionOutput_Construct(kVsAnalogAdjustActionOutput* object, kAlloc alloc);

/**
* Creates a kVsAnalogAdjustActionOutput object and loads the xml settings into the class.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object         The kVsAnalogAdjustActionOutput object
* @param   xml          The xml settings for the action.
* @param   alloc        The allocator to use for constructing the class.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionOutput_Load(kVsAnalogAdjustActionOutput* object, kXml xml, kAlloc alloc);

/**
* Creates an xml object and assigns the input parameters to the xml.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object         The kVsAnalogAdjustActionOutput object
* @param   xml          The xml settings for the action (output).
* @param   alloc        The allocator to use for constructing the xml.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionOutput_Save(kVsAnalogAdjustActionOutput object, kXml* xml, kAlloc alloc);

/**
* Assigns a new value to the kVsAnalogAdjustCorrectionMethod parameter.
* See the kVsAnalogAdjustOutputCorrectionMethod enum for the options.
* Currently there are 3 options, dense look up table (LUT), and linear, and none.
* The Dense LUT will use the dense LUT to correct the Analog Output currents.  (this is the new method, should be more accurate)
* The linear method will correct the Analog Output currents using the two points (per channel) in Adjust.xml (this is the old method)
*
* Note that these corrections will not be applied until the action is invoked.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object         The kVsAnalogAdjustActionOutput object
* @param   option       The new kVsAnalogAdjustCorrectionMethod option.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionOutput_SetCorrectionMethod(kVsAnalogAdjustActionOutput object, kVsAnalogAdjustActionOutputCorrectionMethod option);

/**
* Returns the current correction method stored by the kVsAnalogAdjustActionOutput class.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object         The kVsAnalogAdjustActionOutput object
* @return               The correction method.
*/
kVsFx(kVsAnalogAdjustActionOutputCorrectionMethod) kVsAnalogAdjustActionOutput_CorrectionMethod(kVsAnalogAdjustActionOutput object);

/**
* Validates the kVsAnalogAdjustActionOutput class.
*
* @public               @memberof kVsAnalogAdjustActionOutput
* @param   object         The kVsAnalogAdjustActionOutput object
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionOutput_Validate(kVsAnalogAdjustActionOutput object);

#include <kVision/Vs/kVsAnalogAdjustActionOutput.x.h>


#endif
