#ifndef kVS_ANALOG_ADJUST_X_H
#define kVS_ANALOG_ADJUST_X_H

#include <kApi/kApi.h>
#include <kFireSync/Data/kDataTree.h>

typedef struct kVsAnalogAdjustClass
{
    kObjectClass base;
    k32u sensorId;

    kArray1 channels;
    kSize channelCount;

} kVsAnalogAdjustClass;

kDeclareClassEx(kVs, kVsAnalogAdjust, kObject)

kVsFx(kStatus) kVsAnalogAdjust_Init(kVsAnalogAdjust object, kSize channelCount, kAlloc alloc);

/**
* Creates the data tree object and adds the arrays into the correct locations.  Opposite of the kVsAnalogAdjust_Read function.
*
* @private              @memberof kVsAnalogAdjust
* @param   object       The class object.
* @param   dataTree     The returned data tree.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_Write(kVsAnalogAdjust object, kDataTree tree);

/**
* Releases a kVsAnalogAdjust object.
*
* @private              @memberof kVsAnalogAdjust
* @param   object       The object to be destroyed
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_VRelease(kVsAnalogAdjust object);

/**
* Takes the data tree that has been recently loaded from the sensor and extracts the input and output currents from it.  Opposite of the kVsAnalogAdjust_Write function.
*
* @private              @memberof kVsAnalogAdjust
* @param   object       The class object.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_Read(kVsAnalogAdjust object, kDataTree tree);

#endif
