#ifndef kVS_ANALOG_ADJUST_H
#define kVS_ANALOG_ADJUST_H

#include <kApi/kApi.h>
#include <kVision/Vs/kVsDef.h>
#include <kVision/Common/kVision.h>
#include <kFireSync/Client/kNode.h>

#define kVS_ANALOG_ADJUST_FILE_NAME        "AnalogAdjust.kdat"

/**
* @class       kVsAnalogAdjust
* @extends     kObject
* @ingroup     kVision-Vs
* @brief       Class object for the kVsAnalogAdjust class.
*/
typedef kObject kVsAnalogAdjust;


/**
* Constructs a kVsAnalogAdjust object.
*
* @public               @memberof kVsAnalogAdjust
* @param   object       Destination for the constructed object handle.
* @param   channelCount The number of channels.
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_Construct(kVsAnalogAdjust* object, kSize channelCount, kAlloc alloc);

/**
* Saves the calibration information to disk or to the sensor depending on parameters.
* If node = null it will load the calibration from disk instead of from the sensor.
*
* @public               @memberof kVsAnalogAdjust
* @param   object       The class object.
* @param   node         The sensor node.  If this is null, it will save to disk instead.
* @param   path         The file location to store the resulting output.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_Save(kVsAnalogAdjust object, kNode node, const kChar *path);


/**
* Loads the calibration information from disk or from the sensor depending on parameters.
* If node = null it will load the calibration from disk instead of from the sensor.
*
* @public               @memberof kVsAnalogAdjust
* @param   object       The kVsAnalogAdjust object
* @param   node         The sensor node.  If this is null, it will load from disk instead.
* @param   path         The file location to load the calibration information.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_Load(kVsAnalogAdjust *object, kNode node, const kChar *path, kAlloc alloc);

/**
* Saves the calibration information to a stream.
*
* @public               @memberof kVsAnalogAdjust
* @param   adjust       The class object.
* @param   stream       Output stream handle
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_SaveStream(kVsAnalogAdjust adjust, kStream stream);

/**
* Loads the calibration information from a stream.
*
* @public               @memberof kVsAnalogAdjust
* @param   adjust       Pointer receiving the read calibration information
* @param   stream       Input stream handle
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjust_LoadStream(kVsAnalogAdjust *adjust, kStream stream, kAlloc alloc);

/* Get and Set functions.*/

/**
* Sets the input and output currents for a single channel.
* The currents array needs to have a size that is 2 x stepCount where the stepCount is the number of steps in the correction.
* The currents array is copied by value into the AnalogAdjust class.  It does not take ownership of the original currents array.
*
* @public               @memberof kVsAnalogAdjust
* @param   object       The kVsAnalogAdjust object
* @param   channelIndex The channel the current data corresponds to.
* @param   current      The array of input and output currents.  
* @return               Operation status
*/
kVsFx(kStatus) kVsAnalogAdjust_SetCalibration(kVsAnalogAdjust object, kSize channelIndex, kArray2 currents);

/**
* Returns the input and output currents for a single channel.
* The output array will have a size that is 2 x stepCount where the stepCount is the number of steps in the correction.
* Note that returned array is not a copy.  The user is not responsible for explicitly freeing the memory.
*
* @public               @memberof kVsAnalogAdjust
* @param   object       The kVsAnalogAdjust object
* @param   channelIndex The channel the current data corresponds to.
* @param   current      The array of input and output currents.
* @return               Operation status
*/
kVsFx(kArray2) kVsAnalogAdjust_Calibration(kVsAnalogAdjust object, kSize channelIndex);

/**
* Gets the total number of channels.
*
* @public                @memberof kVsAnalogAdjust
* @param   object        The kVsAnalogAdjust object
* @return                The number of channels
*/
kVsFx(kSize) kVsAnalogAdjust_ChannelCount(kVsAnalogAdjust object);

/**
* Sets the sensorId.  This is stored in the AnalogAdjust file.
*
* @public                @memberof kVsAnalogAdjust
* @param   object        The kVsAnalogAdjust object
* @param   sensorId      The sensorId
* @return                Operation status
*/
kVsFx(kStatus) kVsAnalogAdjust_SetSensorId(kVsAnalogAdjust object, k32u sensorId);

/**
* Gets the sensorId.  This is stored in the AnalogAdjust file.
*
* @public                @memberof kVsAnalogAdjust
* @param   object        The kVsAnalogAdjust object
* @return                The sensor ID
*/
kVsFx(k32u) kVsAnalogAdjust_SensorId(kVsAnalogAdjust object);

#include <kVision/Vs/kVsAnalogAdjust.x.h>


#endif
