/**
* @file    kS3dVolumeCheckAlg.x.h
* @brief   Declares the kS3dVolumeCheckAlg class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKALG_X_H
#define KVISION_KS3D_VOLUMECHECKALG_X_H

#define KS3DVOLUMECHECKALIGN_FINAL_FILTER_COUNT (2)
#define KS3DVOLUMECHECKALIGN_BORDER_EXPAND_RATE (0.8)

typedef struct kS3dVolumeCheckAlgClass
{
    kObjectClass base;
    kS3dVolumeCheckAlign align;    
    kS3dVolumeCheckSubPixLut  subPixLut; 
    kS3dValveSettings   ValvesParams[kS3D_VOLUMECHECK_VALVE_MAX];
    kS3dValveSettings   SparksParams[kS3D_VOLUMECHECK_VALVE_MAX];
    kS3dVolumeCheckValveAlg  valves[kS3D_VOLUMECHECK_VALVE_MAX];
    kS3dVolumeCheckSparkAlg  sparks[kS3D_VOLUMECHECK_VALVE_MAX];
    kPoint3d64f valveCenter[kS3D_VOLUMECHECK_VALVE_MAX];
    kPoint3d64f nominalCenter[kS3D_VOLUMECHECK_VALVE_MAX];
    kPoint64f chamberCenterOffset; 
    kS3dVolumeCheckFilteringParams outlierFilter;
    kS3dVolumeCheckFilteringParams smoothFilter;
    k64f volumeOffset;
    k64f nominalVolume;
    k64f volumeTolerance;

    k64f correctFactor; 
    k32u outputSizeX;   
    k32u outputSizeY;   
    kPoint3d64f inputScale;
    kPoint3d64f outputScale;
    k32u valveCount;
    k32u sparkCount;
    k32u maxAlignRepeat;
    k32u maxRotationRepeat;
    k64f rotationTolerance;
    k64f moveTolerance;
    k32s contourAverageWindow;
    k64f valveSearchStep;
    k64f valveRadiusFactor;
    kArray2 weight;
    kArray2 valid;
    k64f zmin;
    k64f zmax;
    kBool rotationComplete;
    kBool isSubPixLutInit;
    k32s invalidCount;
    k32s invalidRest;
    k64f volume;   
    k64f planeDifference;
    kPoint64f actualOffset;
    kArray2 output;
    kArray2 templt;
    kStatus errorCode;
    kPoint3d64f center;
    k64f rotationAngle;
    k32s measureIndex;
    k32s yStart;
    k32s yEnd;
    k32s xStart;
    k32s xEnd;
    kTimer timer;
    k64s valveTime;
    k64s alignTime;
    k64s segmentTime;
    k64s mapTime;
    k64s totalTime;
    k64s sparkTime;
    k64s filterTime;
    k32s average;
    kS3dVolumeCheckSensorRotationMode rotationMode;

    kArray2 inputData;
    k64f inputXyScale;
    k64f inputZScale;
    kBool isTemplate;
    kBool showDiff;
}kS3dVolumeCheckAlgClass;

kDeclareClassEx(kVs, kS3dVolumeCheckAlg, kObject)

kStatus kS3dVolumeCheckAlg_Init(kS3dVolumeCheckAlg alg, kType classType, kS3dVolumeCheckSubPixLut  subPixLut, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckAlg_VRelease(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_SetDefaultFinalFilter(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_InitValves(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_InitSparks(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_CalculateVolume(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_Transform2D(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_StartValveSoftCover(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_InitOutputMap(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillMainBody(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_CheckHidden(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillValveHoles(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_RescalingOutputMap(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_RescalingOutputMapCheckRange(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillSparkHoles(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_SearchRemainHoles(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_SearchCamberCenter(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillRemainHoles(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_OutlierFiltering(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_Smoothing(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillRemainHolesLeft(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillRemainHolesRight(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillRemainHolesDown(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillRemainHolesUp(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FitBorderContour(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_BorderContourAverageMap(kS3dVolumeCheckAlg alg, k32s halfValue);
kStatus kS3dVolumeCheckAlg_FillReferencePlane(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_CheckPlaneDifference(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_FillAllHolesWithAverageFilter(kS3dVolumeCheckAlg alg);
k64s kS3dVolumeCheckAlg_ElapsedTime(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_StartTimer(kS3dVolumeCheckAlg alg);

kStatus kS3dVolumeCheckAlg_ResamplePoint3d16s(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResamplePoint3d32s(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResamplePoint3d32f(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResamplePoint3d64f(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResampleMap16s(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResampleMap32s(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResampleMap32f(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_ResampleMap64f(kS3dVolumeCheckAlg alg, k64f offset);
kStatus kS3dVolumeCheckAlg_MergeHoleArea(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_AddAverageDifference(kS3dVolumeCheckAlg alg);
kStatus kS3dVolumeCheckAlg_SetDifferenceMap(kS3dVolumeCheckAlg alg);

#define K3DVOLUMECHECKALG(HANDLE) ((kS3dVolumeCheckAlgClass*)(HANDLE))

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKALG_X_H */
