/**
 * @file    kS3dSurfaceGenerator.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kS3D_SURFACE_GENERATOR_X_H
#define kS3D_SURFACE_GENERATOR_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dSurfaceGeneratorClass
{
    kObjectClass base;

    kS3dStereoProfiler profiler;

    kSize outputHeight;
    kSize outputWidth;

    // Merging ///////////////////////////////////////////////////////////
    kArray2 mono[2];
    k64f monoMergeOutlierTolerance; // average multiplier

    kS3dMonoMergeAlg monoMergeAlg;
    kS3dMonoMergeLocalAlg monoMergeLocalAlg;
    kS3dMonoMergeRigidAlg monoMergeRigidAlg;


    // JobQueue support //////////////////////////////////////////////////
    kSize jobInputViewIndex;
    kArray1 jobInputPhaseTable;
    kArray2 jobInputX0;
    kArray2 jobInputX1;
    kSSize jobInputYBegin;
    kSSize jobInputYStep;
    kArray2 jobOutputRanges;

    kVsJobQueue jobQueue;   

} kS3dSurfaceGeneratorClass;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kDeclareClassEx(kVs, kS3dSurfaceGenerator, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dSurfaceGenerator_VInitClone(kS3dSurfaceGenerator alg, kS3dSurfaceGenerator source, kAlloc allocator);
kVsFx(kStatus) kS3dSurfaceGenerator_VRelease(kS3dSurfaceGenerator alg);
kVsFx(kSize)   kS3dSurfaceGenerator_VSize(kS3dSurfaceGenerator alg);

//////////////////////////////////////////////////////////////////////////
//non-exported (private) methods
//////////////////////////////////////////////////////////////////////////

kStatus xkS3dSurfaceGenerator_Init(kS3dSurfaceGenerator alg, kS3dStereoProfiler profiler, kAlloc allocator);

#if defined (K_HAVE_CUDA)
// LookupMapDisparity //
kStatus xkS3dSurfaceGenerator_LookupMapDisparityCuda(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray2 output);

// LookupMapPhase //
kStatus xkS3dSurfaceGenerator_LookupMapPhaseCuda(kS3dSurfaceGenerator alg, kSize viewIndex, kSSize yBegin, kSize yStep, kArray2 x, kArray1 phaseTable, kArray2 output);

// Merges //
kStatus xkS3dSurfaceGenerator_LookupMapMergeRigidCuda(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);
kSize xkS3dSurfaceGenerator_CalculatePointCountCuda(kArray2 points);

// Various //
kStatus xkS3dSurfaceGenerator_CorrectExpansionCuda(kS3dSurfaceGenerator alg, kArray2 output);
kStatus xkS3dSurfaceGenerator_ClipRoiCuda(kS3dSurfaceGenerator alg, kArray2 output);
kStatus xkS3dSurfaceGenerator_ApplyTransformationCuda(kS3dSurfaceGenerator alg, kArray2 output);
#endif



// LookupMapDisparity //
kStatus xkS3dSurfaceGenerator_LookupMapDisparity(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray2 output);
kStatus xkS3dSurfaceGenerator_LookupMapDisparityRows(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray2 output, kSize startRow, kSize rowCount);
kStatus kCall xkS3dSurfaceGenerator_LookupDisparityHandler(kS3dSurfaceGenerator alg, k64u id);

// LookupMapPhase //
kStatus xkS3dSurfaceGenerator_LookupMapPhase(kS3dSurfaceGenerator alg, kSize viewIndex, kSSize yBegin, kSize yStep, kArray2 x, kArray1 phaseTable, kArray2 output);
kStatus xkS3dSurfaceGenerator_LookupMapPhaseRows(kS3dSurfaceGenerator alg, kSize viewIndex, kSSize yBegin, kSize yStep, kArray2 x, kArray1 phaseTable, kArray2 output, kSize startRow, kSize rowCount);
kStatus kCall xkS3dSurfaceGenerator_LookupPhaseHandler(kS3dSurfaceGenerator alg, k64u id);

// LookupMapPhaseDifference //
kStatus xkS3dSurfaceGenerator_LookupMapPhaseDifference(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);

// LookupMapPhaseZDifference //
kStatus xkS3dSurfaceGenerator_LookupMapPhaseZDifference(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);

// Merges //
kStatus xkS3dSurfaceGenerator_LookupMapMergeQuadratic(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);
kStatus xkS3dSurfaceGenerator_LookupMapMergeLocal(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);
kStatus xkS3dSurfaceGenerator_LookupMapMergeRigid(kS3dSurfaceGenerator alg, kSSize yBegin, kSize yStep, kArray2 x0, kArray2 x1, kArray1 phaseTable, kArray2 output);
kSize xkS3dSurfaceGenerator_CalculatePointCount(kArray2 points);

// Various //
kStatus xkS3dSurfaceGenerator_CorrectExpansion(kS3dSurfaceGenerator alg, kArray2 output);
kStatus xkS3dSurfaceGenerator_ClipRoi(kS3dSurfaceGenerator alg, kArray2 output);
kStatus xkS3dSurfaceGenerator_ApplyTransformation(kS3dSurfaceGenerator alg, kArray2 output);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kS3D_SURFACE_GENERATOR_X_H */
