#ifndef LMITECH_KVISION_S3D_STRIPEPATTERN_H_INCLUDED
#define LMITECH_KVISION_S3D_STRIPEPATTERN_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>

typedef kPointer kS3dStripePattern;

typedef struct kS3dStripePatternParams 
{
    k32u width;
    k32u stripeWidth;
    k32u height;
    k32u referenceStepCount;
    k32u stripeStepCount;
    k32u phaseStepCount;
    k32u widePhaseStepCount;
    k32u widePhaseDepth;
    k64f phaseWidth;
    k64f stripeIntensity;
    k64f phaseIntensity;
    k64f uniformity;
} kS3dStripePatternParams;

typedef enum
{
    kS3D_STRIPE_IMAGE_REFERENCE,
    kS3D_STRIPE_IMAGE_STRIPE,
    kS3D_STRIPE_IMAGE_PHASE,
    kS3D_STRIPE_IMAGE_WIDE_PHASE
} kS3dStripeImageType;

kVsFx(kStatus) kS3dStripePattern_Construct(kS3dStripePattern* pattern, const kS3dStripePatternParams* params);
kVsFx(kStatus) kS3dStripePattern_Destroy(kS3dStripePattern pattern);

kVsFx(kStatus) kS3dStripePattern_SetReferenceIntensity(kS3dStripePattern pattern, k32u index, k8u value);

kVsFx(const kS3dStripePatternParams*) kS3dStripePattern_Params(kS3dStripePattern pattern);

kVsFx(kStatus) kS3dStripePattern_Export(kS3dStripePattern pattern, const kChar* path);

kVsFx(kStatus) kS3dStripePattern_ImageList(kS3dStripePattern pattern, kArrayList* images);
kVsFx(kStatus) kS3dStripePattern_Image(kS3dStripePattern pattern, kS3dStripeImageType type, k32u index, kImage* output);
kVsFx(kStatus) kS3dStripePattern_Map(kS3dStripePattern pattern, kArray2* output);
kVsFx(kStatus) kS3dStripePattern_WideMap(kS3dStripePattern pattern, kArray2* output);

kVsFx(kSize) kS3dStripePattern_ImageCount(kS3dStripePattern pattern);
kVsFx(kSize) kS3dStripePattern_LineCount(kS3dStripePattern pattern);

#endif /* #define LMITECH_KVISION_S3D_STRIPEPATTERN_H_INCLUDED */
