/**
* @file    kS3dSpecklePrefilter.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_PRE_FILTER_X_H
#define KS3D_SPECKLE_PRE_FILTER_X_H

#define kS3D_SPECKLE_PRE_FILTER_DEFAULT_FILTER_CAP         (127)
#define kS3D_SPECKLE_PRE_FILTER_DEFAULT_FILTER_WINDOW      (15)
#define kS3D_SPECKLE_PRE_FILTER_DEFAULT_TEXTURE_THRESHOLD  (5)
#define kS3D_SPECKLE_PRE_FILTER_ADAPTIVE_NORM_STDEV_COUNT  (4)

#define kS3D_SPECKLE_PRE_FILTER_HISTOGRAM_SIZE             (k8U_MAX+1)
#define kS3D_SPECKLE_PRE_FILTER_HISTOGRAM_TOLERANCE        (0.0001)

typedef struct kS3dSpecklePrefilterClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;
    k32u filterCap;
    k32u filterWindow;
    k32u textureThreshold;

    kArrayList vSumBuffer;
    kArrayList vSumSqBuffer;
    kArray1 sqrtLut;

    kImage outputTemp;

} kS3dSpecklePrefilterClass;

kDeclareClassEx(kVs, kS3dSpecklePrefilter, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dSpecklePrefilter_VInitClone(kS3dSpecklePrefilter filter, kS3dSpecklePrefilter source, kAlloc allocator);
kVsFx(kStatus) kS3dSpecklePrefilter_VRelease(kS3dSpecklePrefilter filter);

//non-exported (private) methods
kStatus kS3dSpecklePrefilter_Init(kS3dSpecklePrefilter filter, kAlloc allocator);
kStatus kS3dSpecklePrefilter_ErodeAdaptiveNorm(kS3dSpecklePrefilter filter, kImage input, kImage output);

//cast macro

#endif  /* #ifndef KS3D_SPECKLE_PRE_FILTER_X_H */
