/**
* @file    kS3dSgbm.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_MATCH_ALG_SGBM_X_H
#define KS3D_SPECKLE_MATCH_ALG_SGBM_X_H

//actually "if defined(X86{,_64})", because it supports Linux just as well
#if defined(K_WINDOWS)
#   define kS3D_BM_SSE2                     (1)
#endif

#define kS3D_SGBM_DISPARITY_RANGE_GRANULARITY (16)
#define kS3D_SGBM_TAB_OFFSET                  (256 * 4)
#define kS3D_SGBM_TAB_COUNT                   (256 + kS3D_SGBM_TAB_OFFSET * 2)
#if defined(K_MSVC)
#   define kS3D_SGBM_DECL_ALIGNED(x)             __declspec(align(x))
#else
#   define kS3D_SGBM_DECL_ALIGNED(x)            
#endif
#define kS3D_SGBM_ALIGN                       32


#define kS3D_SGBM_SATURATE_16S(V)             ((((k32s)V) < k16S_MIN) ? (k16s)k16S_MIN : (((k32s)V) > k16S_MAX) ? (k16s)k16S_MAX : (k16s)V)
#define kS3D_SGBM_NLR                         (2)
#define kS3D_SGBM_LR_BORDER                   (kS3D_SGBM_NLR - 1)
#define kS3D_SGBM_MAX_COST                    (k16S_MAX)
#define kS3D_SGBM_NR                          (16)
#define kS3D_SGBM_NR2                         (kS3D_SGBM_NR / 2)

typedef struct kS3dSgbmClass
{
    kS3dSpeckleMatchAlgClass base;
    kArrayList buffer;
    kArray1 clipTab;

} kS3dSgbmClass;

kDeclareClassEx(kVs, kS3dSgbm, kS3dSpeckleMatchAlg)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dSgbm_VRelease(kS3dSgbm alg);

kVsFx(kStatus) kS3dSgbm_VRunImpl(kS3dSgbm alg, kImage image0, kImage image1, kArray2 disparity);
kVsFx(kStatus) kS3dSgbm_VSetupImpl(kS3dSgbm alg);
kVsFx(k32u)    kS3dSgbm_VDisparityMarginImpl(kS3dSgbm alg);
kVsFx(k32u)    kS3dSgbm_VDisparityRangeGranularityImpl(kS3dSgbm alg);

//non-exported (private) methods
kStatus kS3dSgbm_Init(kS3dSgbm alg, kAlloc allocator);
kStatus kS3dSgbm_CalculateCostBt(kS3dSgbm alg, const k8u* row1, const k8u* row2, k32s width, k32s minD, k32s maxD, k16s* cost, k8u* buffer, const k8u* tab, k32s tabOfs, k32s ftZero);

//cast macro

#endif  /* #ifndef KS3D_SPECKLE_MATCH_ALG_SGBM_X_H */
