#ifndef LMITECH_KVISION_S3D_RAYCAL_H_INCLUDED
#define LMITECH_KVISION_S3D_RAYCAL_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>

typedef kPointer kS3dRayCal;

typedef struct kS3dRayCalParams 
{
    k32u width;
    k32u height;
    k32u depth;
    k32u xStep;
    k32u yStep;
} kS3dRayCalParams;

kVsFx(kStatus) kS3dRayCal_Construct(kS3dRayCal* cal, const kS3dRayCalParams* params);
kVsFx(kStatus) kS3dRayCal_Load(kS3dRayCal* cal, const kChar* fileName);
kVsFx(kStatus) kS3dRayCal_Store(kS3dRayCal cal, const kChar* filename);
kVsFx(kStatus) kS3dRayCal_Destroy(kS3dRayCal cal);

kVsFx(const kS3dRayCalParams*) kS3dRayCal_Parameters(kS3dRayCal cal);

kVsFx(kStatus) kS3dRayCal_SetId(kS3dRayCal cal, k32u id);
kVsFx(k32u) kS3dRayCal_Id(kS3dRayCal cal);

kVsFx(kStatus) kS3dRayCal_SetTimestamp(kS3dRayCal cal, const kChar* timestamp);
kVsFx(const kChar*) kS3dRayCal_Timestamp(kS3dRayCal cal);

kVsFx(kStatus) kS3dRayCal_SetProjectionAngle(kS3dRayCal cal, k32f angle);
kVsFx(k32f) kS3dRayCal_ProjectionAngle(kS3dRayCal cal);

kVsFx(kStatus) kS3dRayCal_SetProjectionPlane(kS3dRayCal cal, const kPoint3d32f* p, const kPoint3d32f* norm);
kVsFx(kStatus) kS3dRayCal_ProjectionPlane(kS3dRayCal cal, kPoint3d32f* p, kPoint3d32f* norm);

kVsFx(k32f) kS3dRayCal_Position(kS3dRayCal cal, k32u index);
kVsFx(kStatus) kS3dRayCal_SetPosition(kS3dRayCal cal, k32u index, k32f position);

kVsFx(kArray2) kS3dRayCal_XNearAt(kS3dRayCal cal, k32u index);
kVsFx(kArray2) kS3dRayCal_YNearAt(kS3dRayCal cal, k32u index);
kVsFx(kArray2) kS3dRayCal_XFarAt(kS3dRayCal cal, k32u index);
kVsFx(kArray2) kS3dRayCal_YFarAt(kS3dRayCal cal, k32u index);

kVsFx(kArray2) kS3dRayCal_XNearReference(kS3dRayCal cal);
kVsFx(kArray2) kS3dRayCal_YNearReference(kS3dRayCal cal);
kVsFx(kArray2) kS3dRayCal_XFarReference(kS3dRayCal cal);
kVsFx(kArray2) kS3dRayCal_YFarReference(kS3dRayCal cal);

#endif  /* #ifndef LMITECH_KVISION_S3D_RAYCAL_H_INCLUDED */
