#ifndef KVISION_S3D_POINTSSORTER_X_H
#define KVISION_S3D_POINTSSORTER_X_H

#define kS3DPOINTSORTER_THICK  (7)
#define kS3DPOINTSORTER_EXPAND_THICK  (6)
#define kS3DPOINTSORTER_OUTLIER_RATE  (0.02)
#define kS3DPOINTSORTER_CAMERA_SCALE  (0.05)
#define kS3DPOINTSORTER_DEFAULT_ORDER  (3)
#define kS3DPOINTSORTER_DEFAULT_ORDER_MAX  (4)
#define kS3DPOINTSORTER_DEFAULT_START_TOLERANCE  (0.2)
#define kS3DPOINTSORTER_DEFAULT_TOLERANCE  (0.05)

#define kS3DPOINTSORTER_DZDX12  (1)
#define kS3DPOINTSORTER_DZDX21  (2)
#define kS3DPOINTSORTER_DZDY12  (4)
#define kS3DPOINTSORTER_DZDY21  (8)

typedef struct kS3dPointsSorterClass
{
    kObjectClass base;

    k32s imageSizeX;
    k32s imageSizeY;
    k32s gridSizeX;
    k32s gridSizeY;
    k32s mapSizeX;
    k32s mapSizeY;
    kPoint64f center;

    kArray2 indexMap;
    kArray2 gridValue;
    kArray1 nZx;
    kArray1 nZy;
    kArray1 points;
    kArray1 valid;

    kArray1 matX;
    kArray1 matY;
    kArray1 invX;
    kArray1 invY;
    kArray1 vecX;
    kArray1 vecY;
    kS3dPolynomial polynomialX;
    kS3dPolynomial polynomialY;
    kS3dPolynomialMap polynMap;

    k32s order;
    k32s paramSize;
    k32s matSize;
    k32s cornerCount;
    k64f scale;
    k64f camScale;
    k64f startTolerarance;
    k64f tolerarance;
    k64f offsetX, offsetY;

    kArrayList corner;
    kL3dLattice2d  lattice;
} kS3dPointsSorterClass;

kDeclareClassEx(kVs, kS3dPointsSorter, kObject)

kStatus kS3dPointsSorter_Init(kS3dPointsSorter sorter, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dPointsSorter_VRelease(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_Setup(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_FillIndexMap(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_ExpandIndexMap(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_InitCornerDerivative(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_EliminateOutlier(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_PolynomialDerivative3order(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_CalculateOffset(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_SetGridValue(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_AddGridValue(kS3dPointsSorter sorter);
kStatus kS3dPointsSorter_SetLatticePoints(kS3dPointsSorter sorter);

#define S3DPOINTSSORTER(HANDLE) ((kS3dPointsSorterClass*)(HANDLE))

#endif /* #ifndef KVISION_S3D_POINTSSORTER_X_H */
