#ifndef KVISION_kS3D_PHASE_CORRECTION_X_H
#define KVISION_kS3D_PHASE_CORRECTION_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_SEGMENT_MAX_STEP   256
#define kS3D_SEGMENT_MAX_STEP_OFFSET   128
#define kS3D_PHASE_SEGMENT_LIMIT_RATE    0.2

#define kS3D_DEFAULT_MEDIAN_WIDTH    5
#define kS3D_DEFAULT_MEDIAN_REPEAT   2
#define kS3D_DEFAULT_MEDIAN_MAX_REPEAT         4
#define kS3D_DEFAULT_VALID_WIDTH_LIMIT  5
#define kS3D_DEFAULT_REFLECTION_CORRECTION_WIDTH    15
#define kS3D_DEFAULT_REFLECTION_CORRECTION_REPEAT   4
#define kS3D_GRAYMAP_LEVEL_MAX   254

#define kS3D_SEGMENT_DEFAULT_MIN_JUMP_STEP    1
#define kS3D_SEGMENT_DEFAULT_MAX_AREA_NUMBER  2
#define kS3D_SEGMENT_DEFAULT_VALID_WIDTH_LIMIT  30
#define kS3D_SEGMENT_DEFAULT_MAX_REPEAT         10
#define kS3D_SEGMENT_DEFAULT_OUTLIER_FRAGMENT_LIMIT 100

typedef struct kS3dPhaseSegmentItem
{
    k32s mapIndex;
    k32s count;
    k32s segmentIndex;
    k32s step;
    k32s phase;
    k32s maxWidth;
    k32s maxValue;
    k32s maxValue2;
    k32s sumValue;
    k16s histo[kS3D_SEGMENT_MAX_STEP];
    kBool finished;
} kS3dPhaseSegmentItem;


typedef struct kS3dPhaseCorrectionClass
{
    kObjectClass base;

    kVsJobQueue jobQueue;
    kS3dPhaseSegment segment;
    kS3dPhaseMedian median;
    kS3dPhaseExpand expand;
    kS3dPhaseOutlier outlier;
    kArray2 stripePhaseMap;
    kArray2 data;
    kArray2 valid;
    kArray2 groupMap;
    kArray2 countMap;
    kArray1 items;

    k32s imageSizeX; 
    k32s imageSizeY; 

    k32s xStart;
    k32s yStart;
    k32s xEnd;
    k32s yEnd;

    k32s minJumpStep;
    k32s segOffset;
    k32s validWidthLimit;

    k32s aveDelta;
    k32s threshold;

    kBool inversPhase;
    k32s maxRepeat;
    k32s segCount;
    k32s phaseWidth;
    k32s outPhaseWidth;
    k32s outlierArea;
    k32s camIndex;

    k64f offset;
    kBool preferMainArea;

    k32s grayMaxLevel;

    kSize filterMode;
    kSize totalSize;

    k64s sumDelta[16];
    k32s sumCount[16];
    
    kBool runMedianFilter;
    kBool runMultiReflection;
    kBool runOutlierCorrrection;
    kBool runReflectionCorr;

    k32s skinMedianWidth;
    k32s skinMedianRepeat;
    k32s reflectionCorrWidth;
    k32s reflectionCorrRepeat;
    k64f segmentLimitFactor;
    
} kS3dPhaseCorrectionClass;

kDeclareClassEx(kVs, kS3dPhaseCorrection, kObject)

kVsFx(kStatus) kS3dPhaseCorrection_VInitClone(kS3dPhaseCorrection phaseCorr, kS3dPhaseCorrection source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseCorrection_VRelease(kS3dPhaseCorrection phaseCorr);
kVsFx(kSize)   kS3dPhaseCorrection_VSize(kS3dPhaseCorrection phaseCorr);

kVsFx(kStatus) kS3dPhaseCorrection_SetJobQueue(kS3dPhaseCorrection phaseCorr, kVsJobQueue queue);

kStatus kS3dPhaseCorrection_Init(kS3dPhaseCorrection phaseCorr, kType classType, kAlloc alloc);
kStatus kS3dPhaseCorrection_Release(kS3dPhaseCorrection phaseCorr);

kStatus kS3dPhaseCorrection_Setup(kS3dPhaseCorrection phaseCorr);


kStatus kS3dPhaseCorrection_SegmentPhaseMap(kS3dPhaseCorrection phaseCorr);

kStatus kS3dPhaseCorrection_Alignment(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_InitSegmentItems(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_SegmentMaxWidth(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_ExpandMainArea(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_FillBoardHistogram(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_CleanUpSegment(kS3dPhaseCorrection phaseCorr);


k32s kS3dPhaseCorrection_CheckPhaseLimit(k32s phase, k32s refPhase, k32s Lambda, k32s Lambda_2);

kStatus kS3dPhaseCorrection_MedianCorrection(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_FilteringOutlier(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_ResetAlignment(kS3dPhaseCorrection phaseCorr);
//kStatus kS3dPhaseCorrection_ViewMapCopy(kS3dPhaseCorrection phaseCorr);

kStatus kS3dPhaseCorrection_ScalingViewMap(kS3dPhaseCorrection phaseCorr);
kStatus kCall kS3dPhaseCorrection_ScalingViewMapHandler(kS3dPhaseCorrection phaseCorr, k64u id);
kStatus kS3dPhaseCorrection_ScalingViewMapThread(kS3dPhaseCorrection phaseCorr, kSize startRow, kSize rowCount);

kStatus kS3dPhaseCorrection_RescalingViewMap(kS3dPhaseCorrection phaseCorr);
kStatus kS3dPhaseCorrection_RescalingViewMapThread(kS3dPhaseCorrection phaseCorr, kSize startRow, kSize rowCount);
kStatus kCall kS3dPhaseCorrection_RescalingViewMapHandler(kS3dPhaseCorrection phaseCorr, k64u id);

kStatus kS3dPhaseCorrection_PhaseAverage(kS3dPhaseCorrection phaseCorr);
kStatus kCall kS3dPhaseCorrection_PhaseAverageHandler(kS3dPhaseCorrection phaseCorr, k64u id);
kStatus kS3dPhaseCorrection_PhaseAverageThread(kS3dPhaseCorrection phaseCorr, k64s* delta, k32s* count, kSize startRow, kSize rowCount);

kStatus kS3dPhaseCorrection_PhaseSubtraction(kS3dPhaseCorrection phaseCorr);
kStatus kCall kS3dPhaseCorrection_PhaseSubtractionHandler(kS3dPhaseCorrection phaseCorr, k64u id);
kStatus kS3dPhaseCorrection_PhaseSubtractionThread(kS3dPhaseCorrection phaseCorr, kSize startRow, kSize rowCount);
kStatus kS3dPhaseCorrection_MedianReflectionCorrection(kS3dPhaseCorrection phaseCorr);

//kStatus kS3dPhaseCorrection_SaveMapOmc(kS3dPhaseCorrection phaseCorr, kBool after);

#endif
