#ifndef kS3D_PHASE_BLOCK_X_H
#define kS3D_PHASE_BLOCK_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dPhaseBlockInfo.h>
#include <kVision/S3d/kS3dPhaseProcessor.h>
#include <kFireSync/Pipe/kPxPort.h>

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#define kS3D_PHASE_BLOCK_DESCRIPTION    "Phase stereo profiling block"

typedef enum
{
    kS3D_PHASE_BLOCK_INPUT_IMAGE,
    kS3D_PHASE_BLOCK_INPUT_PHASE,
    kS3D_PHASE_BLOCK_INPUT_UNKNOWN

} kS3dPhaseBlockInputType;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseBlockClass
{
    kPxBlockClass base;

    kS3dPhaseBlockInfo settings;

    kPort inImage0;
    kPort inImage1;
    kPort inPhase0;
    kPort inPhase1;

    kPort outRanges;
    kPort outIntensity;
    kPort outPlot0;
    kPort outPlot1;
    kPort outDiag;

    kS3dPhaseProcessor processor;
    kS3dStereoProfiler profiler;

    kArray2 ranges;
    kArray2 intensity;

    kBool imageInputEnabled;
    kSize outputWidth;
    kSize outputHeight;
    kSize imageWidth;
    kSize imageHeight;

    kSize scanCount;

    kCameraPhaseDecoderFormat format;

} kS3dPhaseBlockClass;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kDeclareClassEx(kVs, kS3dPhaseBlock, kPxBlock)

kVsFx(const kChar*) kS3dPhaseBlock_VDescription();
kVsFx(kStatus) kS3dPhaseBlock_VOnSetup(kS3dPhaseBlock block);
kVsFx(kStatus) kS3dPhaseBlock_VOnStart(kS3dPhaseBlock block);
kVsFx(kStatus) kS3dPhaseBlock_VOnPause(kS3dPhaseBlock block);
kVsFx(kStatus) kS3dPhaseBlock_VOnResume(kS3dPhaseBlock block);
kVsFx(kStatus) kS3dPhaseBlock_VOnStop(kS3dPhaseBlock block);
kVsFx(kStatus) kS3dPhaseBlock_VOnReceive(kS3dPhaseBlock block, kPxPort port, kMsgSet msg);

k32s kS3dPhaseBlock_PortViewIndex(kS3dPhaseBlock block, kPxPort port);
kS3dPhaseBlockInputType kS3dPhaseBlock_PortInputType(kS3dPhaseBlock block, kPxPort port);
kStatus kS3dPhaseBlock_ValidateInput(kS3dPhaseBlock block, kS3dPhaseBlockInputType inputType, kObject input);

kStatus kS3dPhaseBlock_SendOutputs(kS3dPhaseBlock block, const kStamp* stamp);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif // #ifndef kS3D_PHASE_BLOCK_X_H
