/**
* @file    kS3dMonoMergeRigidAlgV2.x.h
* @brief   Declares the kS3dMonoMergeRigidAlgV2 class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef kS3D_MONO_MERGE_RIGID_ALG_V2_X_H
#define kS3D_MONO_MERGE_RIGID_ALG_V2_X_H

#define kS3D_MONO_MERGE_RIGID_WEIGHT_SHIFT     (7)
#define kS3D_MONO_MERGE_RIGID_WEIGHT_VALUE     (256)

#define kS3D_MONO_MERGE_MINIMUM_AREA_RATE      (3) 
#define kS3D_MONO_MERGE_OUTLIER_SIGMA_RATE     (4) 
#define kS3D_MONO_MERGE_MONODATA_MAX           (2) 
#define kS3D_MONO_MERGE_REPEAT_MAX             (1) 
#define kS3D_MONO_MERGE_EDGE_WINDOW_DEFAULT    (10) 
#define kS3D_MONO_MERGE_STEP_DEFAULT           (2)

#define kS3D_MONO_MERGE_Z_CORRECTION_DEFAULT   (kTRUE) 
#define kS3D_MONO_MERGE_Z_CORRECTION_TOLERANCE  (0.005)
#define kS3D_MONO_MERGE_Z_CORRECTION_DIFFERENCE_MAX (2)

#define kS3D_MONO_MERGE_TRANSFORM_SHIFT            (15)
#define kS3D_MONO_MERGE_TRANSFORM_SCALE            (1 << kS3D_MONO_MERGE_TRANSFORM_SHIFT)


typedef struct kS3dMonoMergeRigidAlgV2Class
{
    kObjectClass base;
    k32s outputSizeX;
    k32s outputSizeY;

    kL3dTransform3d T[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s diffSum0[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s diffSum[kS3D_MONO_MERGE_MONODATA_MAX];
    k32s Tolerance[kS3D_MONO_MERGE_MONODATA_MAX];
    k32s count[kS3D_MONO_MERGE_MONODATA_MAX];
    k64f mat[kS3D_MONO_MERGE_MONODATA_MAX][kS3D_JAKOBEIGENVALUE_MATRIXSIZE];
    k64s matSum[kS3D_MONO_MERGE_MONODATA_MAX][kS3D_JAKOBEIGENVALUE_MATRIXSIZE];

    k64s sumStereoX[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s sumStereoY[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s sumStereoZ[kS3D_MONO_MERGE_MONODATA_MAX];

    k64s sumMonoX[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s sumMonoY[kS3D_MONO_MERGE_MONODATA_MAX];
    k64s sumMonoZ[kS3D_MONO_MERGE_MONODATA_MAX];

    kPoint3d64f stereoCenter[kS3D_MONO_MERGE_MONODATA_MAX];
    kPoint3d64f monoCenter[kS3D_MONO_MERGE_MONODATA_MAX];

    kArray2 diffZ[kS3D_MONO_MERGE_MONODATA_MAX];
    kArray2 valid;
    kArray2 weight;

    k32s smoothWindow;
    kBool fitScale;

//    k64f a, b;
    k32s step;
    kBool isSetup;
    k32s maxDelta;
    k32s medianWidth;
} kS3dMonoMergeRigidAlgV2Class;

kDeclareClassEx(kVs, kS3dMonoMergeRigidAlgV2, kObject)

kStatus kS3dMonoMergeRigidAlgV2_Init(kS3dMonoMergeRigidAlgV2 alg, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dMonoMergeRigidAlgV2_VRelease(kS3dMonoMergeRigidAlgV2 alg);

kStatus kS3dMonoMergeRigidAlgV2_Setup(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo);
kStatus kS3dMonoMergeRigidAlgV2_SetImageWeight(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_SetValidRange(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);

kStatus kS3dMonoMergeRigidAlgV2_CleanUp(kS3dMonoMergeRigidAlgV2 alg);
kStatus kS3dMonoMergeRigidAlgV2_DifferenceMap(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_Center(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_RotationMatrix(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_Transformation(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_FitZscale(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_Combine(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_SmoothCombine(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);
kStatus kS3dMonoMergeRigidAlgV2_MedianFilterX(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo);
kStatus kS3dMonoMergeRigidAlgV2_MedianFilterY(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo);
kStatus kS3dMonoMergeRigidAlgV2_MedianFilter(kS3dMonoMergeRigidAlgV2 alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);

#endif /* #ifndef kS3D_MONO_MERGE_RIGID_ALG_V2_X_H */
