/**
* @file    kS3dCheckerBoard.x.h
* @brief   Declares the kS3dCheckerBoard class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_CHECKERBOARD_X_H
#define KVISION_S3D_CHECKERBOARD_X_H

#define  kS3D_CHECKERBOARD_X_BIT         32
#define  kS3D_CHECKERBOARD_Y_BIT         16
#define  kS3D_CHECKERBOARD_XY_BIT        48
#define  kS3D_CHECKERBOARD_ELLIPSE_BIT   64

#define kS3D_CHECKERBOARD_DEFAUT_POLYNOMIAL_ORDER     (5)
#define kS3D_CHECKERBOARD_DEFAUT_POLYNOMIAL_STEP     (6)
#define kS3D_CHECKERBOARD_DEFAUT_CAMERA_PIXEL_PITCH   (0.005165)

#define kS3D_CHECKERBOARD_DEFAUT_GRID_WIDTH     (60)
#define kS3D_CHECKERBOARD_DEFAUT_GRID_HEIGHT    (60)

#define kS3D_CHECKERBOARD_ROTATION_ANGLE_TOLERANCE (30)
#define kS3D_CHECKERBOARD_ROTATION_ANGLE_SCALE (0.4)
#define kS3D_CHECKERBOARD_HISTGRAM_ANGLE_TOLERANCE (6)
#define kS3D_CHECKERBOARD_PIXEL_STEP   (2)
#define kS3D_CHECKERBOARD_LOWPASS_WIDTH  (40)
#define kS3D_CHECKERBOARD_RANGE (5)

typedef struct kS3dCheckerBoard_LineGeomItem
{
    k32f c;
    k32s y1, y2;
    k32f phi;
    k32f powX;
    k32f powY;
    k32f dev;
    k32f value;
    k32s Index;
    kBool  bInit;
}kS3dCheckerBoard_LineGeomItem;


typedef struct kS3dCheckerBoardClass
{
    kObjectClass base;

    k32s imageSizeX;
    k32s imageSizeY;
    k32s gridHeight;
    k32s gridWidth;

    k32s order;
    k64f scale;
    k32s step;

    k64f  tScale;
    k32s histoMapSizeX;
    k32s histoMapSizeY;
    k32s xMin, xMax, yMin, yMax;
    k32s lineCountX;
    k32s lineCountY;
    k32s lineLenX;
    k32s lineLenY;
    k64f xPhiDev;
    k64f xCDev;
    k64f yPhiDev;
    k64f yCDev;

    k32s xCount;
    k32s yCount;

    kArray2 histoX;
    kArray2 histoY;
    kArray2 temp;

    kArray2 data;
    kArray2 valid;
    kArray2 segment;

    kArray1 lineX;
    kArray1 lineY;
    kArray1 sumLineX;
    kArray1 sumLineY;

    kArray1 lineGeomX;
    kArray1 lineGeomY;
    kArray1 cosTab;
    kArray1 sinTab;

    kG3dPolynomMap polynMap;
    kS3dEllipseParams ellipse;

    kG3dPolynomial polynMCX;
    kG3dPolynomial polynMCY;
    kG3dPolynomial polynCMX;
    kG3dPolynomial polynCMY;

    k32s markX1, markY1, markX2, markY2;
    k64f contrast;
    k64f average;
    


    kChar calInputPath[kPATH_MAX];
    kImage rawImage;
    kL3dLattice2d  lattice;
    kL3dLattice2d  refLattice;
    kArrayList refCorners;
    kPoint64f refCenter;
    kPoint32s reference;
    kPoint64f point;
    kRect64f world;
        k32s measureIndex;
}kS3dCheckerBoardClass;

kDeclareClassEx(kVs, kS3dCheckerBoard, kObject)

kStatus kS3dCheckerBoard_Init(kS3dCheckerBoard checkerBoard, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dCheckerBoard_VRelease(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_SinCosTable(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_ChessLinesHistogram(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_NormalizeHistoMap(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_DistanceSumMap(kS3dCheckerBoard checkerBoard);

kStatus kS3dCheckerBoard_CreateDerivativeImage(kS3dCheckerBoard checkerBoard);

kStatus kS3dCheckerBoard_InitLineGeomerty(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_CheckLineGeomertyY(kS3dCheckerBoard checkerBoard, kBool blineX);
kStatus kS3dCheckerBoard_LineGeomertyX(kS3dCheckerBoard checkerBoard, kBool blineX);
kStatus kS3dCheckerBoard_CalculateLineGeomertyY(kS3dCheckerBoard checkerBoard, k64f *pPara, kBool blineX);
kStatus kS3dCheckerBoard_DrawImageLine(kS3dCheckerBoard checkerBoard, kBool blineX);
kStatus kS3dCheckerBoard_ExpandImageLine(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_FindMarker(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_EllipseGeometry(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_MoveCenter(kS3dCheckerBoard checkerBoard);

kStatus kS3dCheckerBoard_SetHistoMapRange(kS3dCheckerBoard checkerBoard, kBool blineX);
kStatus kS3dCheckerBoard_CheckPoints(kS3dCheckerBoard checkerBoard, kBool blineX);

kStatus kS3dCheckerBoard_Cleanup(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_Setup(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_InitGridImage(kS3dCheckerBoard checkerBoard, kImage input);


kStatus kS3dCheckerBoard_SetLatticePoints(kS3dCheckerBoard checkerBoard);
kStatus kS3dCheckerBoard_ReferenceLatticeLines(kS3dCheckerBoard checkerBoard, kArrayList* latticeLine);
kStatus kS3dCheckerBoard_ReferenceCornerLines(kS3dCheckerBoard checkerBoard, kArrayList* cornerLine);

#define kS3DCHECKERBOARD(HANDLE) ((kS3dCheckerBoardClass*)(HANDLE))

#endif /* #ifndef KVISION_S3D_CHECKERBOARD_X_H */
