/** 
 * @file    kMp3dTracheidAlg.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_MP3D_TRACHEID_ALG_X_H
#define K_VISION_MP3D_TRACHEID_ALG_X_H

#include <kVision/Common/kNullMath.h>
#include <kVision/Mp3d/kMp3dProfiler.h>
#include <kVision/L3d/kL3dUtilities.h>
#include <kFireSync/Data/kSpot.h>
#include <math.h>
#include <kVision/Mp3d/kMp3dUtilities.h>
#include <kVision/Mp3d/kMp3dSensorCal.h>
#include <kApi/Data/kMath.h>

/**
* Reserved kMp3dTracheidAlg macros.
*
* @relates kMp3dTracheidAlg
* @{ */
#define kMP3D_TRACHEID_ALG_PERSPECTIVE_SHIFT                (14)
#define kMP3D_TRACHEID_ALG_PERSPECTIVE_SCALE                (1 << kMP3D_TRACHEID_ALG_PERSPECTIVE_SHIFT)
#define kMP3D_TRACHEID_ALG_DEFAULT_FLIP_INDEX               (kFALSE)
/** @} */

typedef struct kMp3dTracheidAlgClass 
{
    kObjectClass base;

    kMp3dSensorCal sensorCal;                                   // Sensor calibration record

    kSize viewCount;                                            // View count
    kSize viewSpotCount;                                        // Spot count per view
    kSize halfWindowWidth;                                      // Half of spot window width
    k32u binThreshold;                                          // Binarization threshold
    kSize width[kMP3D_TRACHEID_MAX_VIEW_COUNT];                 // Runtime window width (divided by x subsampling)
    kSize height[kMP3D_TRACHEID_MAX_VIEW_COUNT];                // Runtime window height (divided by y subsampling)
    k32u blackOffset;                                           // Black offset is added to the black level to form overall binarization threshold
    kSize backgroundWidth;                                      // Number of columns for background noise calculation
    kBool flipIndex;                                            // Toggle to reverse spot index order in moment data
    kL3dCameraWindow calWindow[kMP3D_TRACHEID_MAX_VIEW_COUNT];  // Calibration window
    kL3dCameraWindow runWindow[kMP3D_TRACHEID_MAX_VIEW_COUNT];  // Runtime window
    k32s xShift[kMP3D_TRACHEID_MAX_VIEW_COUNT];                 // Shift for x subsampling difference between cal window and run window
    k32s xOffset[kMP3D_TRACHEID_MAX_VIEW_COUNT];                // X offset between cal window and run window
   
    kArray1 runLeftStart;                                       // Lookup tables for run detection.
    kArray1 runLeftEnd;
    kArray1 runRightStart;
    kArray1 runRightEnd;

    kArray1 scaleLut[kMP3D_TRACHEID_MAX_VIEW_COUNT];            // Lookup table for perspective correction scaling factors. Type kPoint16s.
    kBool validScaleArray;                                      // Flag for whether cal file contains valid perspective scale arrays 

    kImage compressedImage;                                     // Buffer for compressed image when alg is used on raw data instead of bin data.

    kSize currentSpotHalfWindow;                                // Window for spot run calculation for the current spot
    kSize minHalfWindowWidth;                                   // Minimum window for spot run calculation to be used in image

} kMp3dTracheidAlgClass;

kDeclareClassEx(kVs, kMp3dTracheidAlg, kObject)

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kMp3dTracheidAlg_VInitClone(kMp3dTracheidAlg tracheid, kMp3dTracheidAlg source, kAlloc allocator);
kVsFx(kStatus) kMp3dTracheidAlg_VRelease(kMp3dTracheidAlg tracheid);

//non-exported (private) methods
kStatus kMp3dTracheidAlg_Init(kMp3dTracheidAlg tracheid, kMp3dSensorCal sensorCal, kSize tracheidWindow, kAlloc allocator);
kStatus kMp3dTracheidAlg_GenerateScaleLut(kMp3dTracheidAlg tracheid);
kStatus kMp3dTracheidAlg_GenerateRunLengthLut(kMp3dTracheidAlg tracheid);
kStatus kMp3dTracheidAlg_CompressImage(kMp3dTracheidAlg tracheid, kImage in, kImage out);
kStatus kMp3dTracheidAlg_UpdateThreshold(kMp3dTracheidAlg tracheid, kImage image);
kStatus kMp3dTracheidAlg_RunCompressed(kMp3dTracheidAlg tracheid, const k8u* binData, const kSpot2* spots, kSize viewIndex, kArray2 moments);
kStatus kMp3dTracheidAlg_RunSpotCompressed(kMp3dTracheidAlg tracheid, const k8u* pImage, kSize viewIndex, k32u x, k32u y0, kPoint16s scales, k32s* pSum, k32s* pSumX, k32s* pSumY, k32s* pSumXX, k32s* pSumXY, k32s* pSumYY);
kStatus kMp3dTracheidAlg_FindRun(kMp3dTracheidAlg tracheid, const k8u *pImage, kSize viewIndex, kSize y, kSize x0, kSize xc, k32u *px0, k32u *px1);

//cast macro

#endif  /* #ifndef K_VISION_MP3D_TRACHEID_ALG_X_H */
