/**
 * @file kMp3dGeoCal.x.h
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
 */

#ifndef K_VISION_MP3D_GEO_CAL_X_H
#define K_VISION_MP3D_GEO_CAL_X_H

#include <kApi/Data/kXml.h>

/**
 * Reserved kMp3dGeoCal macros.
 *
 * @relates kMp3dGeoCal
 * @{ */
#define kMP3D_GEO_CAL_VERSION                            (1)
/** @} */

typedef struct kMp3dGeoCalWindow 
{
    k32u x;
    k32u y;
    k32u width;
    k32u height;
    k32u xSubsampling;
    k32u ySubsampling;

} kMp3dGeoCalWindow;

typedef struct kMp3dGeoCalCamera 
{
    kMp3dGeoCalWindow calWindow;
    kArray1 xResCoeffs;
    kArray1 yResCoeffs;
    kArray1 xCenterCoeffs;
    kArray1 yCenterCoeffs;
    k64f roll;

} kMp3dGeoCalCamera;

typedef struct kMp3dGeoCalClass
{
    kObjectClass base;

    k32u id;
    kText256 timestamp;

    kArray1 cameras;         // Type: kMp3dGeoCalCamera

} kMp3dGeoCalClass;

kDeclareClassEx(kVs, kMp3dGeoCal, kObject)

kStatus kMp3dGeoCal_Init(kMp3dGeoCal cal, kSize cameraCount, kAlloc allocator);
kVsFx(kBool) kMp3dGeoCal_VEquals(kMp3dGeoCal cal, kMp3dGeoCal otherCal);
kVsFx(kStatus) kMp3dGeoCal_VRelease(kMp3dGeoCal cal);
kVsFx(kStatus) kMp3dGeoCal_Read(kMp3dGeoCal cal, kXml xml, kXmlItem root, kAlloc allocator);
kVsFx(kStatus) kMp3dGeoCal_Write(kMp3dGeoCal cal, kXml xml, kXmlItem root);

#endif /* #ifndef K_VISION_MP3D_GEO_CAL_X_H */

