#ifndef LMITECH_KVISION_L3D_SURFACECOMBINER_X_H_INCLUDED
#define LMITECH_KVISION_L3D_SURFACECOMBINER_X_H_INCLUDED

#include <kVision/L3d/kL3dSystemAlignBar.h>
#include <kApi/Data/kMath.h>
#include <kApi/kApiDef.h>

typedef struct kL3dSurfaceCombinerPolygon 
{
    kPoint3d64f topLeft;
    kPoint3d64f topRight;
    kPoint3d64f bottomLeft;
    kPoint3d64f bottomRight;
} kL3dSurfaceCombinerPolygon;


typedef struct kL3dSurfaceCombinerClass 
{
    kArrayList initialSurfaces;
    kArrayList transforms;

    //kArrayList transformedSurfaces;
    //kArrayList reverseTransforms;

    kArrayList forwardRotationTransform;
    kArrayList reverseRotationTransform;

    kArrayList translations;
    kArrayList rotations;

    kArray2 finalSurface;
    kArrayList surfaceFovs;

    kPoint3d64f resolution;
    kRect64f combinedFov;

    k64f encoderResolution;//In mm
} kL3dSurfaceCombinerClass;


kDeclareClassEx(kVs, kL3dSurfaceCombiner, kObject)

/**
* Releases the object.  Call this to delete the SurfaceCombiner class.
*
* @public               @memberof kL3dSurfaceCombiner
* @param   object       The kL3dSurfaceCombiner object handle.
* @return               Operation status.
*/
kVsFx(kStatus) kL3dSurfaceCombiner_VRelease(kL3dSurfaceCombiner object);

/**
* Saves the final combined surface as a heightmap to disk.  The units will be the same as the original surface.  That is, the height in mm divided by the resolution in the z direction.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param   object             The GoSurfaceCombiner class object.
* @param   filename           Filename for the combined surface.
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSurfaceCombiner_SaveHeightMap(kL3dSurfaceCombiner object, const kChar *filename, kArray2 *surface);

/**
* Saves the final combined surface as a heightmap to disk.  The same as SaveHeightmap except that the units will be in mm.
*
* @public                     @memberof kL3dSurfaceCombiner
* @param   object             The GoSurfaceCombiner class object.
* @param   filename           Filename for the combined surface.
* @return                     Operation status.
*/
kVsFx(kStatus) kL3dSurfaceCombiner_SaveDistanceHeightMap(kL3dSurfaceCombiner object, const kChar *filename, kArray2 *surface);

kStatus kL3dSurfaceCombiner_Init(kL3dSurfaceCombiner object, kAlloc alloc);
kStatus kL3dSurfaceCombiner_Release(kL3dSurfaceCombiner object);
kStatus kL3dSurfaceCombiner_CalculateNewSize(kL3dSurfaceCombiner object);
kBool kL3dSurfaceCombiner_OnSurface(kL3dSurfaceCombiner object, k32u surfaceIndex, kPoint3d64f point);
k64f kL3dSurfaceCombiner_GetZValue(kArray2 surface, kPoint3d64f point);
kStatus kL3dSurfaceCombiner_CreateRotationTransforms(kL3dSurfaceCombiner object);

//Only used for testing purposes.

#endif
