#ifndef LMITECH_KVISION_L3D_SEGMENTSORTER_H_INCLUDED
#define LMITECH_KVISION_L3D_SEGMENTSORTER_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>
#include <kFireSync/Data/kPlot.h>

typedef kPointer kL3dSegmentSorter;

typedef struct kL3dSegmentSorterParams 
{
    k32u columnCount; // Number of columns

    k32u centreRange; // Size of the spot image along the centroid axis (pixels)

    k32u capacity;      // Maximum number of considered segments. 
    k32u xMargin;       // Adjacency margin (1/2 window) in the centroid axis (pixels) 
    k32u yMargin;       // Adjacency margin (1/2 window) in the slice axis (pixels)
    k32u minLength;     // Minimum length (end - start slice + 1) for a segment to be considered valid
    k32u minSpotCount;  // Minimum number of spots for a segment to be considered valid
    k32u binSize;       // Size of the adjacency map bin. Should be set to the nearest power of two that's higher than xMargin

    k32u maxIntensityCount;     // Maximum number of the strongest segments to keep. 
    kBool orderByPosition;      // Order segments by position in centroid axis
    kBool resolveSpotOverlap;   // If ovelap between two segments is found, only the spots from the stronger segment (measured by total sum) are kept

} kL3dSegmentSorterParams;

typedef struct kL3dSegmentSorterSpot kL3dSegmentSorterSpot;

struct kL3dSegmentSorterSpot
{
    k32u    centre;
    k16u    slice;
    k16u    strength;
    k16u    width;
    k32s    wsum;

    kL3dSegmentSorterSpot* next;
    kL3dSegmentSorterSpot* prev;

};

typedef struct kL3dSorterSegment 
{
    kBool valid;
    k32s index;
    k32s sum;
    k32s spotCount;

    k32s startSlice;
    k32s endSlice;

    kL3dSegmentSorterSpot* lastSpot;
    kL3dSegmentSorterSpot* firstSpot;

    k32s trackingCentre;
    k32s trackingCentreSum;
    k32s trackingSumCount;
    k32s centreSum;
    k32s centre;
    kL3dSegmentSorterSpot* currentSpot;
} kL3dSorterSegment;

kVsFx(kStatus) kL3dSegmentSorter_Construct(kL3dSegmentSorter* sorter, const kL3dSegmentSorterParams* params);
kVsFx(kStatus) kL3dSegmentSorter_Destroy(kL3dSegmentSorter sorter);

kVsFx(kStatus) kL3dSegmentSorter_Run(kL3dSegmentSorter sorter, kL3dSegmentSorterSpot* spots, k32u count);
kVsFx(kL3dSorterSegment*) kL3dSegmentSorter_At(kL3dSegmentSorter sorter, k32u index);
kVsFx(k32u) kL3dSegmentSorter_Count(kL3dSegmentSorter sorter);

kVsFx(kStatus) kL3dSegmentSorter_Plot(kL3dSegmentSorter sorter, kImage image, kBool columnBased, kPlot* plot);

kVsFx(kStatus) kL3dSegmentSorter_SpotsToSegmentSpots(kL3dSegmentSorter sorter, kArrayList spots, kArrayList segmentSpots);
kVsFx(kStatus) kL3dSegmentSorter_SpotsFromSegmentSpots(kL3dSegmentSorter sorter, kArrayList segmentSpots, kArrayList spots);
kVsFx(kStatus) kL3dSegmentSorter_OrderBySlice(kL3dSegmentSorter sorter, kArrayList segmentSpots);

#endif      /* #ifndef LMITECH_KVISION_L3D_SEGMENTSORTER_H_INCLUDED */
