#ifndef LMITECH_KVISION_L3D_ZRANGECALDATA_H_INCLUDED
#define LMITECH_KVISION_L3D_ZRANGECALDATA_H_INCLUDED

#include <kVision/L3d/kL3dCalData.h>
#include <kFireSync/Data/kSpot.h>
#include <kApi/Data/kArray2.h>

typedef struct kL3dRangeCalDataClass 
{
    kL3dCalDataClass base;

    k32u centreCount;
    k32u centreStep;
    k32u centreOffset;

    k32u sliceCount;
    k32u sliceStep;

    kArray2 zLut;
    kArray2 xLut;
    kArray2 yLut;

} kL3dRangeCalDataClass;

kDeclareClassEx(kVs, kL3dRangeCalData, kL3dCalData)
kDeclareValueEx(kVs, kL3dRangeCalDataParams, kValue)
kDeclareValueEx(kVs, kL3dRangeCalDataChannel, kValue)

kVsFx(kStatus) kL3dRangeCalData_Init(kL3dRangeCalData calData, kType type, kL3dRangeCalDataParams* params, kAlloc allocator);
kStatus kL3dRangeCalData_Read(kL3dRangeCalData calData, kDataTree tree, kDataTreeItem item);

kVsFx(kStatus) kL3dRangeCalData_VRelease(kL3dRangeCalData calData);
kStatus kL3dRangeCalData_Release(kL3dRangeCalData calData);

kVsFx(kStatus) kL3dRangeCalData_VAssign(kL3dRangeCalData calData, kL3dRangeCalData source);
kVsFx(kStatus) kL3dRangeCalData_VStore(kL3dRangeCalData calData, kDataTree tree, kDataTreeItem item);
kVsFx(kL3dCalDataType) kL3dRangeCalData_VType(kL3dCalData calData);

#endif /* #ifndef LMITECH_KVISION_L3D_ZRANGECALDATA_H_INCLUDED */
