#ifndef LMITECH_KVISION_L3D_POLYNOMIAL_H_INCLUDED
#define LMITECH_KVISION_L3D_POLYNOMIAL_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>
#include <kVision/Common/kPolynomial.h>

#define kL3D_POLYNOMIAL_INVALID_ORDER (k32U_NULL)

typedef kPointer kL3dPolynomial;

kVsFx(kStatus) kL3dPolynomial_Import(kL3dPolynomial polynomial, kPolynomial src);
kVsFx(k64f)    kL3dPolynomial_Apply(kL3dPolynomial polynomial, k64f x);
kVsFx(kStatus) kL3dPolynomial_ApplyN(kL3dPolynomial polynomial, k64f* x, k64f* f, k32u count);
kVsFx(kStatus) kL3dPolynomial_Clear(kL3dPolynomial poly);
kVsFx(kBool)   kL3dPolynomial_IsValid(kL3dPolynomial poly);
kVsFx(k32u)    kL3dPolynomial_Order(kL3dPolynomial poly);
kVsFx(kStatus) kL3dPolynomial_Assign(kL3dPolynomial poly, kL3dPolynomial src);

kVsFx(kStatus) kL3dPolynomial_AddC(kL3dPolynomial poly, k64f offset, kL3dPolynomial result);
kVsFx(kStatus) kL3dPolynomial_MulC(kL3dPolynomial poly, k64f scale, kL3dPolynomial result);
kVsFx(kStatus) kL3dPolynomial_Add(kL3dPolynomial poly1, kL3dPolynomial poly2, kL3dPolynomial result);
kVsFx(kStatus) kL3dPolynomial_Sub(kL3dPolynomial poly1, kL3dPolynomial poly2, kL3dPolynomial result);

kVsFx(k32u) kL3dPolynomial_ItemCount(k32u order);

#endif /* #ifndef LMITECH_KVISION_L3D_POLYNOMIAL_H_INCLUDED */
