/** 
 * @file    kL3dLutActionInfo.x.h
 * 
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef LMITECH_KVISION_L3D_LUT_ACTION_INFO_X_H_INCLUDED
#define LMITECH_KVISION_L3D_LUT_ACTION_INFO_X_H_INCLUDED

#include <kVision/L3d/kL3dSensorCal.h>

typedef struct kL3dLutActionInfoClass
{
    kObjectClass base; 

    k32u viewIndex;
    kText256 calFileName;

    k32s testPattern;
    k32u intensityMultiplier;

    k64f xResolution;
    k64f zResolution;

    kL3dTransform2d transform;
    kRect64f roi;
    kBool exportLuts;
    kBool useLegacy;

} kL3dLutActionInfoClass; 

kDeclareClassEx(kVs, kL3dLutActionInfo, kObject)

kVsFx(kStatus) kL3dLutActionInfo_Init(kL3dLutActionInfo info, kType type, kAlloc alloc);
kVsFx(kStatus) kL3dLutActionInfo_VRelease(kL3dLutActionInfo info);

#endif
