#ifndef LMITECH_KVISION_L3D_HDRALG_H_INCLUDED
#define LMITECH_KVISION_L3D_HDRALG_H_INCLUDED

#include <kVision/L3d/kL3dCommon.h>

typedef kPointer kL3dHdrAlg; 

typedef struct kL3dHdrAlgParams 
{
    k32u imageWidth;
    k32u imageHeight;
    kType outputType;   // k16s, k32s, k32f, k64f
} kL3dHdrAlgParams;

kVsFx(kStatus) kL3dHdrAlg_Construct(kL3dHdrAlg* alg, const kL3dHdrAlgParams* params);
kVsFx(kStatus) kL3dHdrAlg_Update(kL3dHdrAlg alg, kImage image, k32u exposure);
kVsFx(kStatus) kL3dHdrAlg_Result(kL3dHdrAlg alg, kImage* image);
kVsFx(kStatus) kL3dHdrAlg_Destroy(kL3dHdrAlg alg);

kVsFx(kStatus) kL3dHdrAlg_SetTargetExposure(kL3dHdrAlg alg, k64f exposure);
kVsFx(kStatus) kL3dHdrAlg_SetReference(kL3dHdrAlg alg, kImage image);

kVsFx(kStatus) kL3dHdrAlg_Clear(kL3dHdrAlg alg);

#endif /* #ifndef LMITECH_KVISION_L3D_HDRALG_H_INCLUDED */
