/**
* @file    kG3dContourTemplate.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3DCONTOURTEMPLATE_X_H
#define KVISION_kG3DCONTOURTEMPLATE_X_H

#define kG3D_CONTOURTEMPLATE_MATRX_SIZE   16
#define kG3D_CONTOURTEMPLATE_VECTOR_SIZE   4

typedef struct kG3dContourTemplateClass
{
    kObjectClass base;
    kText256 SampleName;
    k64s SampleID;
    k64s SensorID;
    k32s trackCount;
    kPoint3d64f scale;
    kPoint3d64f bmpScale;
    kG3dAffineAlginMode alignMode;
    kG3dAffineTransformModeType transMode;
    kBool useIntensityMap;
    kBool useBitmapAsRef;
    kBool useFixedTransform;

    k64f posTolerance;
    k64f frameThick;

    kG3dAffineTransform affineTrans;
    kArray1 referencePoints[kG3D_AFFINE_MATCHING_MAP_END];
    kArray1 measurePoints[kG3D_AFFINE_MATCHING_MAP_END];

    kG3dClosedContourType closedContor;

    kArrayList refTracks;
    kArrayList bitmapTracks;
    kArrayList heightMapTracks;

    kArrayList InterProfiles;
    kArray1 refTransform;
    kArray1 transform;
    
    k64f overflowOffset;
    k64f gapsOffset;

    kBool success;
    k64f deviation;

    kG3dTrackMaskDataType currentTrack;
    k32s trackIndex;

    kSize classSize;
    k32s bitmapSizeX;
    k32s bitmapSizeY;
    k32s outImageSizeX, outImageSizeY;

    k64f sysOffsetX;
    k64f sysOffsetY;
    k64f sysCorrX;
    k64f sysCorrY;

    kArray1 refCorr;
    kArray1 measCorr;

    GdkGlueBandDefaultMagnetType sampleType;
    GdkGlueBandSensorMode sensorMode;
    GdkGlueBandOperationMode operationMode;

    k32s aveWindowWidth;
    k64f outlierMinRate;
    k64f outlierMaxRate;
    k32s mainMapRotation;
    k32s buddyMapRotation;
    k32s bitmapRotation;
    kBool useCustomizedOrder;
    k32s transCorrectionMode;
} kG3dContourTemplateClass;

kDeclareClassEx(kVs, kG3dContourTemplate, kObject)

kStatus kG3dContourTemplate_Init(kG3dContourTemplate mask, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dContourTemplate_VInitClone(kG3dContourTemplate mask, kG3dContourTemplate source, kAlloc allocator);
kVsFx(kSize)   kG3dContourTemplate_VSize(kG3dContourTemplate mask);
kVsFx(kStatus) kG3dContourTemplate_VRelease(kG3dContourTemplate mask);

kVsFx(kArray1) kG3dContourTemplate_ReferencePoints(kG3dContourTemplate mask, k32s index);
kVsFx(kArrayList) kG3dContourTemplate_ReferenceTracks(kG3dContourTemplate mask);
kVsFx(kStatus) kG3dContourTemplate_SetPositionTolerance(kG3dContourTemplate mask, k64f tol);
kVsFx(k64f) kG3dContourTemplate_PositionTolerance(kG3dContourTemplate mask);
kVsFx(k64f) kG3dContourTemplate_BitmapPositionToleranceInPixel(kG3dContourTemplate mask);
kVsFx(k64f) kG3dContourTemplate_HeightmapPositionToleranceInPixel(kG3dContourTemplate mask);
kVsFx(kStatus) kG3dContourTemplate_SetSysOffsetX(kG3dContourTemplate mask, k64f offset);
kVsFx(kStatus) kG3dContourTemplate_SetSysOffsetY(kG3dContourTemplate mask, k64f offset);
kVsFx(k64f) kG3dContourTemplate_SysOffsetX(kG3dContourTemplate mask);
kVsFx(k64f) kG3dContourTemplate_SysOffsetY(kG3dContourTemplate mask);


kStatus kG3dContourTemplate_WriteTree5(kG3dContourTemplate mask, const kChar* fileName);
kStatus kG3dContourTemplate_ReadTree5(kG3dContourTemplate mask, kDataTree tree, kDataTreeItem item);
kStatus kG3dContourTemplate_Release(kG3dContourTemplate mask);

kStatus kG3dContourTemplate_AddBitmapTrack(kG3dContourTemplate mask, k32s lineIndex);

//kStatus kG3dContourTemplate_CalculateAffineMatrix(kG3dContourTemplate mask, kArray1 ref, kArray1 measure, kL3dTransform3d* T);
//kStatus kG3dContourTemplate_CalculateScalingMatrix(kG3dContourTemplate mask, kArray1 ref, kArray1 measure, kL3dTransform3d* T);
//kStatus kG3dContourTemplate_CalculateRigidMatrix(kG3dContourTemplate mask, kArray1 ref, kArray1 measure, kL3dTransform3d* T);

kStatus kG3dContourTemplate_ClearBitmapTracks(kG3dContourTemplate mask);
kStatus kG3dContourTemplate_ClearReferenceTracks(kG3dContourTemplate mask);

kStatus kG3dContourTemplate_CalculateTrackContour(kG3dContourTemplate mask, kArray1 inContour, kArray1 outContour, k32s newCount);

#endif  /* KVISION_kG3DCONTOURTEMPLATE_X_H */
