/**
* @file    kG3dAffineTransform.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_AFFINETRANSFORM_X_H
#define KVISION_kS3D_AFFINETRANSFORM_X_H

#define kG3D_AFFINETRANSFORM_MATRX_SIZE   16
#define kG3D_AFFINETRANSFORM_VECTOR_SIZE   4
#define kG3D_AFFINETRANSFORM_REPEAT_COUNT  3
#define kG3D_AFFINETRANSFORM_POINT_MINIMUM  4
#define kG3D_AFFINETRANSFORM_SIGMA_FOLD     3
#define kG3D_SCALINGTRANSFORM_VECTOR_SIZE   3

typedef struct kG3dAffineTransformClass
{
    kObjectClass base;
    kArray1 refPoints;
    kArray1 measurePoints;

    kBool success;
    k64f deviation;
    kG3dAffineTransformModeType mode;
    kL3dTransform3d T;
    k64f pMat[kG3D_AFFINETRANSFORM_MATRX_SIZE];
    k64f pInv[kG3D_AFFINETRANSFORM_MATRX_SIZE];
    k64f pVecX[kG3D_AFFINETRANSFORM_VECTOR_SIZE];
    k64f pVecY[kG3D_AFFINETRANSFORM_VECTOR_SIZE];
    k64f tol;
} kG3dAffineTransformClass;

kDeclareClassEx(kVs, kG3dAffineTransform, kObject)

kStatus kG3dAffineTransform_Init(kG3dAffineTransform affineTrans, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dAffineTransform_VInitClone(kG3dAffineTransform affineTrans, kG3dAffineTransform source, kAlloc allocator);
kVsFx(kSize)   kG3dAffineTransform_VSize(kG3dAffineTransform affineTrans);
kVsFx(kStatus) kG3dAffineTransform_VRelease(kG3dAffineTransform affineTrans);

kVsFx(kStatus) kG3dAffineTransform_CalculateAffineMatrix(kG3dAffineTransform affineTrans);
kVsFx(kStatus) kG3dAffineTransform_CalculateScalingMatrix(kG3dAffineTransform affineTrans);
kVsFx(kStatus) kG3dAffineTransform_CalculateRigidMatrix(kG3dAffineTransform affineTrans);

#endif  /* KVISION_KG3D_AFFINETRANSFORM_X_H */
