/**
* @file    kG3dAffineMergeHeightMap.x.h
* @brief   
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_kG3D_AFFINEMERGEHEIGHTMAP_X_H
#define KVISION_kG3D_AFFINEMERGEHEIGHTMAP_X_H

typedef struct kG3dAffineMergeHeightMapClass
{
    kObjectClass base;
    kArray2 heightMap;
    kArray2 buddyMap;
    kArray2 mainIntensityMap;
    kArray2 buddyIntensityMap;
    kArray2 outIntensityMap;
    kArray2 outBitmapMap;
    kArray2 outputHeightMap;
    kArray2 inputHeightMap;
    kImage bitmap;
    kArray2 differenceMap;
    kArray2 tempMap;
    kArray2 validMap;

    kL3dTransform3d heightmap1To2;
    kBool diffMapInit;
    k32s imageSizeX, imageSizeY;
    kPoint3d64f scale;
    kPoint3d64f scale2;
    kBool transformUsed;
    k64f a, b, c;
    k64f sumX, sumY, sumZ, sumXX, sumXY, sumXZ, sumYY, sumYZ, sum;

    k64s dev2Sum;
    k32s devCount;
    k16s dev;
    kBool success;
    kBool flipBitmap;

    kChar* diffFileName;
    k32s sampleIndex;
    k32s repeatIndex;
} kG3dAffineMergeHeightMapClass;

kDeclareClassEx(kVs, kG3dAffineMergeHeightMap, kObject)

kStatus kG3dAffineMergeHeightMap_Init(kG3dAffineMergeHeightMap merge, kType classType, kAlloc alloc);

kVsFx(kStatus) kG3dAffineMergeHeightMap_VInitClone(kG3dAffineMergeHeightMap merge, kG3dAffineMergeHeightMap source, kAlloc allocator);
kVsFx(kSize)   kG3dAffineMergeHeightMap_VSize(kG3dAffineMergeHeightMap merge);
kVsFx(kStatus) kG3dAffineMergeHeightMap_VRelease(kG3dAffineMergeHeightMap merge);

kStatus kG3dAffineMergeHeightMap_Setup(kG3dAffineMergeHeightMap merge, kBool isHeightMap);
kStatus kG3dAffineMergeHeightMap_TransformHeightmap(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_FitDifferencePlane(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_CombineHeightmap(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_Release(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_Deviation(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_Outlier(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_TransformIntensityMap(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_TransformBitmap(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_TransformHeightmap2(kG3dAffineMergeHeightMap merge);
kStatus kG3dAffineMergeHeightMap_TransformMaskMap(kG3dAffineMergeHeightMap merge);

#endif  /* KVISION_kG3D_AFFINEMERGEHEIGHTMAP_X_H */
