#ifndef LMITECH_KXPOLYNOMIAL_FIT_H_INCLUDED
#define LMITECH_KXPOLYNOMIAL_FIT_H_INCLUDED

#include <kApi/Data/kArray2.h>

typedef struct kPolynomialFitClass 
{
    kObjectClass base;
    kArray2 fitData;
    k32s maxOrder;
    k64f orderPenalty;
    k64f targetError;
} kPolynomialFitClass;

kDeclareClassEx(kVs, kPolynomialFit, kObject)

kVsFx(kStatus) kPolynomialFit_Init(kPolynomialFit fit, kType classType, k32s maxOrder, kAlloc allocator);
kVsFx(kStatus) kPolynomialFit_VRelease(kPolynomialFit fit);
kVsFx(kStatus) kPolynomialFit_Select(kPolynomialFit fit, const k64f* x, const k64f* f, kSize count, kPolynomial function);
kVsFx(kStatus) kPolynomialFit_ApplyImpl(kPolynomialFit fit, const k64f* x, const k64f* f, kSize count, kPolynomial function);

#define kPOLYNOMIAL_FIT_ORDER(FIT)              kxPOLYNOMIAL_FIT_ORDER(FIT)
#define kPOLYNOMIAL_FIT_ORDERPENALTY(FIT)       kxPOLYNOMIAL_FIT_ORDER_PENALTY(FIT)
#define kPOLYNOMIAL_FIT_TARGETERROR(FIT)        kxPOLYNOMIAL_FIT_TARGET_ERROR(FIT)

#define kPOLYNOMIAL_FIT(FIT)                     ((kPolynomialFitClass*)(FIT))
#define kPOLYNOMIAL_FIT_VTABLE(FIT)              ((kPolynomialFitVtable*)kOBJECT_INFO(FIT)->vtable)
#define kxPOLYNOMIAL_FIT_ORDER(FIT)              (kPOLYNOMIAL_FIT(FIT)->maxOrder)
#define kxPOLYNOMIAL_FIT_ORDER_PENALTY(FIT)      (kPOLYNOMIAL_FIT(FIT)->orderPenalty)
#define kxPOLYNOMIAL_FIT_TARGET_ERROR(FIT)       (kPOLYNOMIAL_FIT(FIT)->targetError)
#define kxPOLYNOMIAL_FIT_FIT_DATA(FIT)           (kPOLYNOMIAL_FIT(FIT)->fitData)

#endif
