#ifndef LMITECH_KXBLOB_H_INCLUDED
#define LMITECH_KXBLOB_H_INCLUDED

#define kGetFeat(space)     ((space)->featspace + (space)->blob[(space)->irun])
#define kMAX_RL_PER_LINE    1280   // max rl per line
#define kLINE_OVERFLOW      0x0001 // line overflow
#define kFEAT_OVERFLOW      0x0002 // feat overflow

typedef struct kRL 
{
    k32u pos; // position
    k32u cnt; // count
} kRL;

typedef struct kRLSpace 
{
    k32u error;                  // Error flag
    k32u irun;                   // Index of current run
    kRL *run;                    // Pointer to current run
    kRL line;                    // Copy of line run (header for the line)
    k32u blob[kMAX_RL_PER_LINE]; // Index in featspace for run irun (remember: too big for M200 stack)
    k32u maxfeat;                // Maximum number of feat that can be stored
    k32u nfeat;                  // Index of first free entry in featspace
    kBlobItem *featspace;        // Pointer to the feat space
} kRLSpace;// 
// State of the labeling process for a line of GRPs

typedef struct kBlobClass 
{
    kObjectClass base;          // func
    k32s nSize;                 // size
    k32u nMaxRL;                // maxRL
    k32u nMaxBlobs;             // maxBlobs
    kRL *pRL;                   // RL pointer
    kBlobItem *pData;           // data pointer
    kRLSpace *runspace;         // State of current line (only used in kBlobLabel, need early allocation)
    kRLSpace *prevspace;        // State of previous line (only used in kBlobLabel, need early allocation)
} kBlobClass;//
// this is a blob

kDeclareClassEx(kVs, kBlob, kObject)

kVsFx(kStatus) kBlob_Init(kBlob blob, kType classType, k32u nMaxRL, k32u nMaxBlobs, kAlloc allocator);
kVsFx(kStatus) kBlob_VRelease(kBlob blob);
kVsFx(kStatus) kBlob_VInitClone(kBlob blob, kBlob source, kAlloc allocator);
kVsFx(kStatus) kBlob_VRelease(kBlob blob);
kVsFx(kSize)   kBlob_VSize(kBlob blob);

#define kBLOB(LOCK)                             ((kBlobClass*)(LOCK))
#define kxBLOB_DATA(BLOB)                       (kBLOB(BLOB)->pData)
#define kxBLOB_COUNT(BLOB)                      ((k32u)kBLOB(BLOB)->nSize)

#endif      /* #ifndef LMITECH_KXBLOB_H_INCLUDED */
