/** 
 * @file    kSensorIdentity.h
 * @brief   Declares the kSensorIdentity class. 
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_SENSOR_IDENTITY_H
#define K_FIRESYNC_SENSOR_IDENTITY_H

#include <kFireSync/kFsDef.h>

/**
 * Id.xml filename.
 *
 * @relates kSensorIdentity
 */
#define kSENSOR_IDENTITY_FILENAME               "Id.xml"
#define kSENSOR_IDENTITY_TEMP_FILENAME          "/temp/Id.xml"
 /** @} */

/**
 * @class       kSensorIdentity
 * @extends     kObject
 * @ingroup     kFireSync-Utils
 * @brief       Manages Id.xml parsing and serialization.
 */
//typedef kObject kSensorIdentity;             --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSensorIdentity object.
 *
 * The kSensorIdentity object is initially empty - fields must be individually
 * populated using the appropriate mutators
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    Destination for the constructed object handle.
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_Construct(kSensorIdentity* identity, kAlloc allocator);

/** 
 * Loads a SensorIdentity object from file.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    Destination for the constructed object handle.
 * @param   fileName    Input file path (expects an XML document).
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_Load(kSensorIdentity* identity, const kChar* fileName, kAlloc allocator);

/** 
 * Saves the SensorIdentity object to file.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   fileName    Output file path (expects an XML document).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_Save(kSensorIdentity identity, const kChar* fileName);

/** 
 * Constructs a SensorIdentity object from an XML object.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    Destination for the constructed object handle.
 * @param   xml         XML object to be read.
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_FromXml(kSensorIdentity* identity, kXml xml, kAlloc allocator);

/** 
 * Constructs an XML object from the SensorIdentity object.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   xml         Destination for the constructed XML object.
 * @param   allocator   Memory allocator (or kNULL for default).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_ToXml(kSensorIdentity identity, kXml* xml, kAlloc allocator);

/**
* Clears all fields in the SensorIdentity object.
*
* @public               @memberof kSensorIdentity
* @param    identity    SensorIdentity object.
* @return               SensorIdentity schema version.
*/
kFsFx(kStatus) kSensorIdentity_Clear(kSensorIdentity identity);

/**
* Clears ALL fields, and initializes the kSensorIdentity object with the current set of default fields
*
* @public               @memberof kSensorIdentity
* @param    identity    SensorIdentity object.
* @return               SensorIdentity schema version.
*/
kFsFx(kStatus) kSensorIdentity_InitFields(kSensorIdentity identity);

/**
* Clears only the default fields, and initializes them back to the default values
*
* @public               @memberof kSensorIdentity
* @param    identity    SensorIdentity object.
* @return               SensorIdentity schema version.
*/
kFsFx(kStatus) kSensorIdentity_InitOnlyDefaultFields(kSensorIdentity identity);

/**
* Reports whether the kSensorIdentity object contains the current set of default fields
*
* @public               @memberof kSensorIdentity
* @param    identity    SensorIdentity object.
* @return               kTRUE if all fields exist, kFALSE otherwise.
*/
kFsFx(kBool) kSensorIdentity_DefaultFieldsExist(kSensorIdentity identity);

/**
* Reports whether two kSensorIdentity objects represent the same sensor model.
*
* Unlike kObject_Equals, this function ignores the PartNumber, SerialNumber, Version,
* and IsControl fields (provided they exist).
*
* @public               @memberof kSensorIdentity
* @param    a           SensorIdentity object.
* @param    b           SensorIdentity object.
* @return               kTRUE if remaining fields equal, kFALSE otherwise.
*/
kFsFx(kBool) kSensorIdentity_Equivalent(kSensorIdentity a, kSensorIdentity b);

/** 
 * Returns the SensorIdentity schema version (defined by kSENSOR_IDENTITY_VERSION).
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              SensorIdentity schema version. 
 */
kFsFx(k32u) kSensorIdentity_Version(kSensorIdentity identity);

/** 
 * Reports whether a field exists with the specified name.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_FieldExists(kSensorIdentity identity, const kChar* name);

/** 
 * Returns the specified field as a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @return              Field value as a k32u (or kNULL if the field doesn't exist). 
 */
kFsFx(k32u) kSensorIdentity_Field32u(kSensorIdentity identity, const kChar* name);

/** 
 * Returns the specified field as a k64f value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @return              Field value as a k64f (or kNULL if the field doesn't exist). 
 */
kFsFx(k64f) kSensorIdentity_Field64f(kSensorIdentity identity, const kChar* name);

/** 
 * Returns the specified field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @return              Field value as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_FieldText(kSensorIdentity identity, const kChar* name);

/** 
 * Creates or modifies the specified field from a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @param   value       Field value as a k32u (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetField32u(kSensorIdentity identity, const kChar* name, k32u value);

/** 
 * Creates or modifies the specified field from a k64f value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @param   value       Field value as a k64f (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetField64f(kSensorIdentity identity, const kChar* name, k64f value);

/** 
 * Creates or modifies the specified field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   name        Field name.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetFieldText(kSensorIdentity identity, const kChar* name, const kChar* value);

/** 
 * Reports whether the PartNumber field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_PartNumberExists(kSensorIdentity identity);

/** 
 * Returns the PartNumber field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of PartNumber as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_PartNumber(kSensorIdentity identity);

/** 
 * Creates or modifies the PartNumber field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetPartNumber(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the SerialNumber field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_SerialNumberExists(kSensorIdentity identity);

/** 
 * Returns the SerialNumber field as a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of SerialNumber as a k32u (or kNULL if the field doesn't exist). 
 */
kFsFx(k32u) kSensorIdentity_SerialNumber(kSensorIdentity identity);

/** 
 * Creates or modifies the SerialNumber field from a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a k32u (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetSerialNumber(kSensorIdentity identity, k32u value);

/** 
 * Reports whether the Class field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_ClassExists(kSensorIdentity identity);

/** 
 * Returns the Class field as a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of Class as a k32u (or kNULL if the field doesn't exist). 
 */
kFsFx(k32u) kSensorIdentity_Class(kSensorIdentity identity);

/** 
 * Creates or modifies the Class field from a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a k32u (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetClass(kSensorIdentity identity, k32u value);

/** 
 * Reports whether the Model field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_ModelExists(kSensorIdentity identity);

/** 
 * Returns the Model field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of Model as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_Model(kSensorIdentity identity);

/** 
 * Creates or modifies the Model field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetModel(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the ModelNumber field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_ModelNumberExists(kSensorIdentity identity);

/** 
 * Returns the ModelNumber field as a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of ModelNumber as a k32u value (or kNULL if the field doesn't exist). 
 */
kFsFx(k32u) kSensorIdentity_ModelNumber(kSensorIdentity identity);

/** 
 * Creates or modifies the ModelNumber field from a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a k32u value (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetModelNumber(kSensorIdentity identity, k32u value);

/** 
 * Reports whether the LaserClass field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_LaserClassExists(kSensorIdentity identity);

/** 
 * Returns the LaserClass field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of LaserClass as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_LaserClass(kSensorIdentity identity);

/** 
 * Creates or modifies the LaserClass field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetLaserClass(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the Spectrum field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_SpectrumExists(kSensorIdentity identity);

/** 
 * Returns the Spectrum field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of Spectrum as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_Spectrum(kSensorIdentity identity);

/** 
 * Creates or modifies the Spectrum field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetSpectrum(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the Package field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_PackageExists(kSensorIdentity identity);

/** 
 * Returns the Package field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of Package as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_Package(kSensorIdentity identity);

/** 
 * Creates or modifies the Package field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetPackage(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the HardwareRevision field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_HardwareRevisionExists(kSensorIdentity identity);

/** 
 * Returns the HardwareRevision field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of HardwareRevision as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_HardwareRevision(kSensorIdentity identity);

/** 
 * Creates or modifies the HardwareRevision field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetHardwareRevision(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the Version field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_FirmwareVersionExists(kSensorIdentity identity);

/** 
 * Returns the Version field as a kVersion object.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of Version as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_FirmwareVersion(kSensorIdentity identity);

/** 
 * Creates or modifies the Version field from a kVersion object.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetFirmwareVersion(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the CompatibleFirmwareTag field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_CompatibleFirmwareTagExists(kSensorIdentity identity);

/** 
 * Returns the CompatibleFirmwareTag field as a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of CompatibleFirmwareTag as a character array (or "" if the field doesn't exist). 
 */
kFsFx(const kChar*) kSensorIdentity_CompatibleFirmwareTag(kSensorIdentity identity);

/** 
 * Creates or modifies the CompatibleFirmwareTag field from a character array.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a character array (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetCompatibleFirmwareTag(kSensorIdentity identity, const kChar* value);

/** 
 * Reports whether the IsControl field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_IsControlExists(kSensorIdentity identity);

/** 
 * Returns the IsControl field as a kBool value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of IsControl as a kBool value (or kFALSE if the field doesn't exist). 
 */
kFsFx(kBool) kSensorIdentity_IsControl(kSensorIdentity identity);

/** 
 * Creates or modifies the IsControl field from a kBool value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a kBool value (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetIsControl(kSensorIdentity identity, kBool value);

/** 
 * Reports whether the OptionCode field exists.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              kTRUE if field exists, kFALSE otherwise. 
 */
kFsFx(kBool) kSensorIdentity_OptionCodeExists(kSensorIdentity identity);

/** 
 * Returns the OptionCode field as a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Contents of OptionCode as a k32u value (or kNULL if the field doesn't exist). 
 */
kFsFx(k32u) kSensorIdentity_OptionCode(kSensorIdentity identity);

/** 
 * Creates or modifies the OptionCode field from a k32u value.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   value       Field value as a k32u value (if the field doesn't exist, it will be created).
 * @return              Operation status. 
 */
kFsFx(kStatus) kSensorIdentity_SetOptionCode(kSensorIdentity identity, k32u value);

/** 
 * Returns the number of fields defined in the identity object.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @return              Number of fields in identity. 
 */
kFsFx(kSize) kSensorIdentity_FieldCount(kSensorIdentity identity);

/** 
 * Returns the field name at the specified index.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   index       Entry index for field name.
 * @return              Field name as a character array (or "" if index exceeds the number of entries). 
 */
kFsFx(const kChar*) kSensorIdentity_FieldNameAt(kSensorIdentity identity, kSize index);

/** 
 * Returns the field value at the specified index.
 *
 * @public              @memberof kSensorIdentity
 * @param   identity    SensorIdentity object.
 * @param   index       Entry index for field value.
 * @return              Field value as a character array (or "" if index exceeds the number of entries). 
 */
kFsFx(const kChar*) kSensorIdentity_FieldValueAt(kSensorIdentity identity, kSize index);

#include <kFireSync/Utils/kSensorIdentity.x.h>

#endif  /* #ifndef K_FIRESYNC_SENSOR_IDENTITY_H */
