#ifndef K_LD_MODEL_X_H
#define K_LD_MODEL_X_H

#include <kApi/kApi.h>

#define kLD_MODEL_VERSION   (1)

#define kLD_MODEL_LD12FX_POWER_ENABLED             (kTRUE)
#define kLD_MODEL_LD12FX_LIMIT_ENABLED             (kTRUE)
#define kLD_MODEL_LD12FX_OUTPUT_MIN                (3)
#define kLD_MODEL_LD12FX_OUTPUT_MAX                (80)
#define kLD_MODEL_LD12FX_TEMP_MIN                  (k64F_NULL)      //Unconfigured
#define kLD_MODEL_LD12FX_TEMP_MAX                  (k64F_NULL)      
#define kLD_MODEL_LD12FX_TEMP_REFERENCE            (kLD_MODEL_TEMPERATURE_REFERENCE_INTERNAL)
#define kLD_MODEL_LD12FX_TEMP_REFERENCE_TOL        (30.0)
#define kLD_MODEL_LD12FX_POWER_TEMP_COMPENSATED    (kFALSE)
#define kLD_MODEL_LD12FX_POWER_TEMP_DELTA_COEFF    (0)
#define kLD_MODEL_LD12FX_LIMIT_TEMP_COMPENSATED    (kFALSE)
#define kLD_MODEL_LD12FX_LIMIT_TEMP_DELTA_COEFF    (-0.437)
#define kLD_MODEL_LD12FX_PRIME_COUNT               (1)              //Number of exposures required for light priming.
#define kLD_MODEL_LD12FX_PRIME_EXPOSURE            (30000)          //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

#define kLD_MODEL_LD16EX_POWER_ENABLED (kTRUE)
#define kLD_MODEL_LD16EX_LIMIT_ENABLED (kTRUE)
#define kLD_MODEL_LD16EX_OUTPUT_MIN (3)
#define kLD_MODEL_LD16EX_OUTPUT_MAX (28)
#define kLD_MODEL_LD16EX_TEMP_MIN (k64F_NULL) //Unconfigured
#define kLD_MODEL_LD16EX_TEMP_MAX (k64F_NULL) 
#define kLD_MODEL_LD16EX_TEMP_REFERENCE (kLD_MODEL_TEMPERATURE_REFERENCE_NONE)
#define kLD_MODEL_LD16EX_TEMP_REFERENCE_TOL (0)
#define kLD_MODEL_LD16EX_POWER_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16EX_POWER_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16EX_LIMIT_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16EX_LIMIT_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16EX_PRIME_COUNT (1)                //Number of exposures required for light priming.
#define kLD_MODEL_LD16EX_PRIME_EXPOSURE (12000)         //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

#define kLD_MODEL_LD16GX_POWER_ENABLED (kTRUE)
#define kLD_MODEL_LD16GX_LIMIT_ENABLED (kTRUE)
#define kLD_MODEL_LD16GX_OUTPUT_MIN (2.5)
#define kLD_MODEL_LD16GX_OUTPUT_MAX (120)
#define kLD_MODEL_LD16GX_TEMP_MIN (k64F_NULL) //Unconfigured
#define kLD_MODEL_LD16GX_TEMP_MAX (k64F_NULL) 
#define kLD_MODEL_LD16GX_TEMP_REFERENCE (kLD_MODEL_TEMPERATURE_REFERENCE_NONE)
#define kLD_MODEL_LD16GX_TEMP_REFERENCE_TOL (0)
#define kLD_MODEL_LD16GX_POWER_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16GX_POWER_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16GX_LIMIT_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16GX_LIMIT_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16GX_PRIME_COUNT (0)          //Number of exposures required for light priming.
#define kLD_MODEL_LD16GX_PRIME_EXPOSURE (0)       //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

#define kLD_MODEL_LD16HX_POWER_ENABLED (kTRUE)
#define kLD_MODEL_LD16HX_LIMIT_ENABLED (kTRUE)
#define kLD_MODEL_LD16HX_OUTPUT_MIN (2.5)
#define kLD_MODEL_LD16HX_OUTPUT_MAX (120)
#define kLD_MODEL_LD16HX_TEMP_MIN (k64F_NULL) //Unconfigured
#define kLD_MODEL_LD16HX_TEMP_MAX (k64F_NULL) 
#define kLD_MODEL_LD16HX_TEMP_REFERENCE (kLD_MODEL_TEMPERATURE_REFERENCE_NONE)
#define kLD_MODEL_LD16HX_TEMP_REFERENCE_TOL (0)
#define kLD_MODEL_LD16HX_POWER_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16HX_POWER_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16HX_LIMIT_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD16HX_LIMIT_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD16HX_PRIME_COUNT (1)            //Number of exposures required for light priming.
#define kLD_MODEL_LD16HX_PRIME_EXPOSURE (30000)     //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

#define kLD_MODEL_LD12EX_POWER_ENABLED (kTRUE)
#define kLD_MODEL_LD12EX_LIMIT_ENABLED (kFALSE)
#define kLD_MODEL_LD12EX_OUTPUT_MIN (3)
#define kLD_MODEL_LD12EX_OUTPUT_MAX (28)
#define kLD_MODEL_LD12EX_TEMP_MIN (k64F_NULL) //Unconfigured
#define kLD_MODEL_LD12EX_TEMP_MAX (k64F_NULL) 
#define kLD_MODEL_LD12EX_TEMP_REFERENCE (kLD_MODEL_TEMPERATURE_REFERENCE_NONE)
#define kLD_MODEL_LD12EX_TEMP_REFERENCE_TOL (0)
#define kLD_MODEL_LD12EX_POWER_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD12EX_POWER_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD12EX_LIMIT_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD12EX_LIMIT_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD12EX_PRIME_COUNT (1)            //Number of exposures required for light priming.
#define kLD_MODEL_LD12EX_PRIME_EXPOSURE (12000)     //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

#define kLD_MODEL_LD12GX_POWER_ENABLED (kTRUE)
#define kLD_MODEL_LD12GX_LIMIT_ENABLED (kTRUE)
#define kLD_MODEL_LD12GX_OUTPUT_MIN (2.5)
#define kLD_MODEL_LD12GX_OUTPUT_MAX (120)
#define kLD_MODEL_LD12GX_TEMP_MIN (k64F_NULL) //Unconfigured
#define kLD_MODEL_LD12GX_TEMP_MAX (k64F_NULL) 
#define kLD_MODEL_LD12GX_TEMP_REFERENCE (kLD_MODEL_TEMPERATURE_REFERENCE_NONE)
#define kLD_MODEL_LD12GX_TEMP_REFERENCE_TOL (0)
#define kLD_MODEL_LD12GX_POWER_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD12GX_POWER_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD12GX_LIMIT_TEMP_COMPENSATED (kFALSE)
#define kLD_MODEL_LD12GX_LIMIT_TEMP_DELTA_COEFF (0)
#define kLD_MODEL_LD12GX_PRIME_COUNT (0)          //Number of exposures required for light priming.
#define kLD_MODEL_LD12GX_PRIME_EXPOSURE (0)       //Exposure time required each light priming exposure, in ns (characterized in "FSH-2123 Summary")

typedef struct kLdModelClass
{
    kObjectClass base;

    kLightModel lightModel;
    kLightDiodeModel diodeModel;

    kBool powerEnabled;
    kBool limitEnabled;

    k64f outputMin;
    k64f outputMax;

    k64f tempMin;
    k64f tempMax;

    kLdModelTempReference tempReference;
    k64f tempReferenceTolerance;

    kBool powerTempCompensated;
    k64f powerTempCompensationCoeff;

    kBool limitTempCompensated;
    k64f limitTempCompensationCoeff;

    k32u primeCount;                //number of priming exposures to execute
    k64u primeExposure;             //duration of priming exposure (FS ns)

} kLdModelClass;

kDeclareClassEx(kFs, kLdModel, kObject)

//forward declaration
kFsFx(kStatus) kLdModel_Construct(kLdModel* model, kLightModel lightModel, kLightDiodeModel diodeModel, kBool tolerateUnknown, kAlloc alloc);

kFsFx(kStatus) kLdModel_Init(kLdModel model, kLightModel lightModel, kLightDiodeModel diodeModel, kBool tolerateUnknown, kAlloc alloc);

kFsFx(kStatus) kLdModel_Write(kLdModel model, kXml xml, kXmlItem item);
kFsFx(kStatus) kLdModel_VRelease(kLdModel model);
kFsFx(kStatus) kLdModel_Read(kLdModel model, kXml xml, kXmlItem item);

/**
* Saves the model object to local storage under the specified path
*
* @public               @memberof kLdCal
* @param   model        The class object.
* @param   path         The file location to store the resulting output.
* @return               Operation status.
*/
kFsFx(kStatus) kLdModel_Save(kLdModel model, const kChar *path);

/**
* Saves the model object to a stream
*
* @public               @memberof kLdCal
* @param   model        The class object.
* @param   stream       Output stream object
* @return               Operation status.
*/
kFsFx(kStatus) kLdModel_SaveStream(kLdModel model, kStream stream);

/**
* Formats the light model property into an internal id (string), to facilitate future changes to enumerated values
*
* @public               @memberof kLdCal
* @param   model        Model enumerator
* @return               String matching the model enumerator or kNULL if the enumerator is not recognized
*/
kFsFx(const kChar*) kLdModel_FormatLightModel(kLightModel model);

/**
* Parses the light model string. If the string does not match any of the supported drivers, returns kLIGHT_MODEL_NULL
*
* @public               @memberof kLdCal
* @return               Light model type corresponding to the parsed string or kLIGHT_MODEL_NULL if match cannot be found
*/
kFsFx(kLightModel) kLdModel_ParseLightModel(const kChar* modelName);

kFsFx(kStatus) kLdModel_ConfigureLd12fx(kLdModel model);
kFsFx(kStatus) kLdModel_ConfigureLd12e(kLdModel model);
kFsFx(kStatus) kLdModel_ConfigureLd12g(kLdModel model);
kFsFx(kStatus) kLdModel_ConfigureLd16e(kLdModel model);
kFsFx(kStatus) kLdModel_ConfigureLd16g(kLdModel model);
kFsFx(kStatus) kLdModel_ConfigureLd16h(kLdModel model);
/**
* Functions used to construct a blank object and configure behaviour parameters for a custom light model. 
* These may be needed in custom development code, while model parameters are still being determined.
*
* At runtime, a model should either be loaded from storage (kLdModel_Load) or constructed (kLdModel_Construct)
* in order to use pre-determined behaviour parameters.
*/
kFsFx(kStatus) kLdModel_ConstructNew(kLdModel* model, kLightModel lightModel, kAlloc alloc);
kFsFx(kStatus) kLdModel_EnableLimit(kLdModel model, kBool enable);
kFsFx(kStatus) kLdModel_EnablePower(kLdModel model, kBool enable);
kFsFx(kStatus) kLdModel_SetOutputRange(kLdModel model, k64f outputMin, k64f outputMax);
kFsFx(kStatus) kLdModel_SetTempRange(kLdModel model, k64f tempMin, k64f tempMax);
kFsFx(kStatus) kLdModel_SetTempReference(kLdModel model, kLdModelTempReference reference);
kFsFx(kStatus) kLdModel_SetTempReferenceTolerance(kLdModel model, k64f tolerance);

kFsFx(kStatus) kLdModel_EnablePowerCompensation(kLdModel model, kBool enable);
kFsFx(kStatus) kLdModel_SetPowerCompensationCoeff(kLdModel model, k64f coeff);

kFsFx(kStatus) kLdModel_EnableLimitCompensation(kLdModel model, kBool enable);
kFsFx(kStatus) kLdModel_SetLimitCompensationCoeff(kLdModel model, k64f coeff);

kInlineFx(kStatus) kLdModel_Construct(kLdModel* model, kLightModel lightModel, kLightDiodeModel diodeModel, kAlloc alloc)
{
    return kLdModel_Construct(model, lightModel, diodeModel, kFALSE, alloc);
}

#endif
