/** 
 * @file    kUpgScriptRunner.h
 * @brief   Declares the kUpgScriptRunner class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kFS_UPG_SCRIPT_RUNNER_H
#define kFS_UPG_SCRIPT_RUNNER_H

#include <kFireSync/kFsDef.h>
#include <kFireSync/Upgrade/kUpgScript.h>
#include <kFireSync/Data/kPropertyList.h>

/**
 * Executes an upgrade script and produces a list of applicable actions.
 *
 * @class       kUpgScriptRunner
 * @extends     kObject
 * @ingroup     kFireSync-Upgrade
 */
typedef kObject kUpgScriptRunner;

/** @cond */
kDeclareClassEx(kFs, kUpgScriptRunner, kObject)
/** @endcond */

kFsFx(kStatus) kUpgScriptRunner_Construct(kUpgScriptRunner* runner, kAlloc alloc);

kFsFx(kStatus) kUpgScriptRunner_Run(kUpgScriptRunner runner, kUpgScript script, kPropertyList properties);

kFsFx(kStatus) kUpgScriptRunner_Status(kUpgScriptRunner runner);

kFsFx(kSize) kUpgScriptRunner_ActionCount(kUpgScriptRunner runner);
kFsFx(kUpgAction) kUpgScriptRunner_ActionAt(kUpgScriptRunner runner, kSize index);

kFsFx(kSize) kUpgScriptRunner_ErrorCount(kUpgScriptRunner runner);
kFsFx(const kChar*) kUpgScriptRunner_ErrorAt(kUpgScriptRunner runner, kSize index);

#endif
