/** 
 * @file    kSvDataOut.h
 * @brief   Declares the kSvDataOut class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_DATA_OUT_H
#define K_FIRESYC_SERVER_DATA_OUT_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvDataOutStats
 * @extends kValue
 * @ingroup kFireSync-Server-Network
 * @brief   Run-time statistics for the data output service. 
 */
typedef struct kSvDataOutStats
{
    k64u bytesWritten;      ///< Total bytes written. 
    k64u bytesEnqueued;     ///< Current bytes awaiting transmission.
    k64u itemsEnqueued;     ///< Current items awaiting transmission.
    k64u throughput;        ///< Output rate (bytes/sec). 
    k64u dropCount;         ///< Total messages dropped. 
} kSvDataOutStats; 

/**
 * @internal
 * @class   kSvDataOut
 * @extends kObject
 * @ingroup kFireSync-Server-Network
 * @brief   Represents the data output service.
 */
//typedef kObject kSvDataOut;      --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kSvDataOut object.
 *
 * @public              @memberof kSvDataOut
 * @param   service     Destination for the constructed object handle. 
 * @param   node        Parent/owner.  
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvDataOut_Construct(kSvDataOut* service, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvDataOut_SetLocalEndPoint(kSvDataOut service, kIpAddress address, k32u port);
kFsFx(kIpEndPoint) kSvDataOut_LocalEndPoint(kSvDataOut service);

kFsFx(kStatus) kSvDataOut_StartService(kSvDataOut service);
kFsFx(kStatus) kSvDataOut_StopService(kSvDataOut service);

kFsFx(kStatus) kSvDataOut_EndSession(kSvDataOut service, kBool synchronizeData);

kFsFx(kStatus) kSvDataOut_AddAppChannel(kSvDataOut service, const k16u* ports, kSize portCount, kCallbackFx function, kPointer receiver, kSvDataOutApp* appChannel);
kFsFx(kStatus) kSvDataOut_RemoveAppChannel(kSvDataOut service, kSvDataOutApp appChannel);

kFsFx(kStatus) kSvDataOut_ClearStats(kSvDataOut service);
kFsFx(kStatus) kSvDataOut_Stats(kSvDataOut service, kSvDataOutStats* stats);

#include <kFireSync/Server/Network/kSvDataOut.x.h>

#endif
