/** 
 * @file    kSvPipe.h
 * @brief   Declares the kSvPipe class and related types. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_PIPE_H
#define K_FIRESYC_SERVER_PIPE_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvPipe
 * @extends kObject
 * @ingroup kFireSync-Server-Frameworks
 * @brief   Manages configuration and execution of a kPxPipe instance. 
 */
//typedef kObject kSvPipe;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvPipe object.
 *
 * @public              @memberof kSvPipe
 * @param   pipe        Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvPipe_Construct(kSvPipe* pipe, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvPipe_Format(kSvPipe pipe, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvPipe_Parse(kSvPipe pipe, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvPipe_AddSystemBlock(kSvPipe pipe, kPxBlock block);
kFsFx(kStatus) kSvPipe_RemoveSystemBlock(kSvPipe pipe, kPxBlock block);

kFsFx(kStatus) kSvPipe_ValidateBlockConfig(kSvPipe pipe, kXml config);

kFsFx(kStatus) kSvPipe_Start(kSvPipe pipe);
kFsFx(kStatus) kSvPipe_Engage(kSvPipe pipe);
kFsFx(kStatus) kSvPipe_Stop(kSvPipe pipe);
kFsFx(kStatus) kSvPipe_Pause(kSvPipe pipe);
kFsFx(kStatus) kSvPipe_Resume(kSvPipe pipe);

kFsFx(kStatus) kSvPipe_StartReplay(kSvPipe pipe);
kFsFx(kStatus) kSvPipe_Replay(kSvPipe pipe, kObject input, kArrayList output);

kFsFx(kAlloc) kSvPipe_MessageAlloc(kSvPipe pipe); 
kFsFx(kStatus) kSvPipe_ClearMessageAlloc(kSvPipe pipe); 

#include <kFireSync/Server/Frameworks/kSvPipe.x.h>

#endif

