/** 
 * @file    kSvActions.h
 * @brief   Declares the kSvActions class and related types. 
 *
 * @internal
 * Copyright (C) 2014-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYC_SERVER_ACTIONS_H
#define K_FIRESYC_SERVER_ACTIONS_H

#include <kFireSync/Server/kSvDef.h>

/**
 * @internal
 * @class   kSvActions
 * @extends kObject
 * @ingroup kFireSync-Server-Frameworks
 * @brief   Manages configuration and execution of kAxAction instances. 
 */
//typedef kObject kSvActions;          --forward-declared in kFsDef.x.h

/** 
 * Constructs a kSvActions object.
 *
 * @public              @memberof kSvActions
 * @param   actions     Destination for the constructed object handle. 
 * @param   node        Server node (parent). 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) kSvActions_Construct(kSvActions* actions, kSvNode node, kAlloc allocator);

kFsFx(kStatus) kSvActions_Format(kSvActions actions, kXml xml, kXmlItem item);
kFsFx(kStatus) kSvActions_Parse(kSvActions actions, kXml xml, kXmlItem item);

kFsFx(kStatus) kSvActions_ValidateConfig(kSvActions actions, kXml config);

kFsFx(kStatus) kSvActions_InvokeAction(kSvActions actions, const kChar* typeName, kXml config, kObject input, kObject* output);
kFsFx(kStatus) kSvActions_InvokeNamedAction(kSvActions actions, const kChar* name, kObject input, kObject* output);

kFsFx(kStatus) kSvActions_Boot(kSvActions actions);
kFsFx(kStatus) kSvActions_Start(kSvActions actions);
kFsFx(kStatus) kSvActions_Stop(kSvActions actions);
kFsFx(kStatus) kSvActions_Pause(kSvActions actions);
kFsFx(kStatus) kSvActions_Resume(kSvActions actions);

//TODO: camera calibration need to be refactored such that it's a standard/integrated feature, not an action
kFsFx(kStatus) kSvActions_CalibrateCamera(kSvActions actions); 

kFsFx(kStatus) kSvActions_SetActionHandler(kSvActions actions, kCallbackFx function, kPointer receiver); 

kFsFx(kStatus) kSvActions_ExecuteActions(kSvActions actions, kPointer args); 

#include <kFireSync/Server/Frameworks/kSvActions.x.h>

#endif

