/** 
 * @file    kPxReplayPipe.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_REPLAY_PIPE_X_H
#define K_FIRESYNC_PX_REPLAY_PIPE_X_H

#include <kFireSync/Pipe/kPxPipe.h>
#include <kApi/Threads/kMsgQueue.h>

#define kPX_REPLAY_PIPE_MAX_ITERATIONS        (102400)          ///< Maximum number of messages that can be processed as a result of a single input.
                                                                ///< Used to break cycles resulting from route configuration errors. 

typedef struct kPxReplayPipeClass
{
    kPxPipeClass base;

    kAlloc messageAlloc;                    //Message allocator. 
                                            
    kArrayList blocks;                      //List of processing blocks -- kArrayList<kPxBlock>. 
    kArrayList routes;                      //List of routes -- kArrayList<kRouteEntry>. 
                                            
    kQueue messages;                        //Unprocessed messages -- kQueue<kMsgInfo>. 
    kMsgQueue asyncMessages;                //Unprocessed asynchronous messages -- kMsgQueue<kMsgInfo>. 
    kArrayList output;                      //Output messages intercepted from i/o blocks. 
                                            
    kAtomic32s executionStatus;             //Pipe execution status.
                                            
    kHealthProbe messageDropProbe;          //Health probe for input message drops. 
    kHealthProbe bytesEnqueuedProbe;        //Health probe for bytes of input data pending processing.
    kHealthProbe itemsEnqueuedProbe;        //Health probe for messages of input data pending processing.
    kHealthProbe executionStatusProbe;      //Health probe for execution status.
    kHealthProbe executionErrorTotalProbe;  //Health probe for total execution errors since start of the health log. 

} kPxReplayPipeClass; 

kDeclareClassEx(kFs, kPxReplayPipe, kPxPipe)
        
kFsFx(kStatus) kPxReplayPipe_Init(kPxReplayPipe pipe, kType type, k32u nodeId, kPxEnviron pipeEnviron, kAlloc alloc); 

kFsFx(kStatus) kPxReplayPipe_VRelease(kPxReplayPipe pipe);

kFsFx(kStatus) kPxReplayPipe_VSetMaxQueueSize(kPxReplayPipe pipe, kSize size);
kFsFx(kStatus) kPxReplayPipe_VSetMaxQueueCount(kPxReplayPipe pipe, kSize count);
kFsFx(kStatus) kPxReplayPipe_VClear(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VAddBlocks(kPxReplayPipe pipe, const kPxBlock* blocks, kSize count);
kFsFx(kStatus) kPxReplayPipe_VAddRoutes(kPxReplayPipe pipe, const kRouteEntry* routes, kSize count); 
kFsFx(kStatus) kPxReplayPipe_VStart(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VEngage(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VStop(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VPause(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VResume(kPxReplayPipe pipe);
kFsFx(kStatus) kPxReplayPipe_VReplay(kPxReplayPipe pipe, kMsgInfo message);
kFsFx(kStatus) kPxReplayPipe_VUpdateStats(kPxReplayPipe pipe);

kFsFx(kStatus) kPxReplayPipe_OnSend(kPxReplayPipe pipe, kPxPort port, kMsgSet msg);
kFsFx(kStatus) kPxReplayPipe_OnSendSync(kPxReplayPipe pipe, kPxPort port, kMsgSet msg);
kFsFx(kStatus) kPxReplayPipe_OnSendAsync(kPxReplayPipe pipe, kPxPort port, kMsgSet msg);

kFsFx(kStatus) kPxReplayPipe_ClearConnections(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_EnumerateConnections(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_FindPort(kPxReplayPipe pipe, k32u blockId, k32u portId, kPxPort* port); 

kFsFx(kStatus) kPxReplayPipe_Process(kPxReplayPipe pipe); 

kFsFx(kStatus) kPxReplayPipe_StartBlocks(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_EngageBlocks(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_StopBlocks(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_PauseBlocks(kPxReplayPipe pipe); 
kFsFx(kStatus) kPxReplayPipe_ResumeBlocks(kPxReplayPipe pipe); 

kFsFx(kStatus) kPxReplayPipe_OnInputQueueDrop(kPxReplayPipe pipe, kMsgQueue queue, kMsgQueueDropArgs* args);
kFsFx(kStatus) kPxReplayPipe_NotifyDrop(kPxReplayPipe pipe);

#endif
