/** 
 * @file    kPxIoBlock.h
 * @brief   Declares the kPxIoBlock type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PX_IO_BLOCK_H
#define K_FIRESYNC_PX_IO_BLOCK_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPxIoBlock
 * @extends kPxBlock
 * @ingroup kFireSync-Pipe
 * @brief   Pipe block that accepts external input or emits external output.
 *
 * kPxIoBlock can be used to interface external modules (e.g. cameras) to the pipe processing 
 * environment. To submit messages to the pipe, output ports can be defined and the thread-safe 
 * kPxBlock_Send function can be used to send messages. To receive messages from the pipe, 
 * input ports can be defined and the kPxIoBlock_SetReceiveHandler can be used to hook messages
 * received on those ports. 
 * 
 * This block type can also be used in unit testing to exchange messagse with a kPxPipe instance. 
 */
//typedef kObject kPxIoBlock;        --forward-declared in kFsDef.x.h

/** 
 * Sets a callback to hook messages received by this block. 
 *
 * @public                  @memberof kPxIoBlock
 * @param   block           Block object. 
 * @param   function        Callback function.
 * @param   receiver        Callback receiver. 
 * @return                  Operation status. 
 */
 kFsFx(kStatus) kPxIoBlock_SetReceiveHandler(kPxIoBlock block, kCallbackFx function, kPointer receiver); 

/**
 * Sends an output message from this block. 
 * 
 * This method can be used internally by a pipe engine to emit output from a kPxIoBlock instance. 
 *
 * @public                  @memberof kPxIoBlock
 * @param   block           Block object.
 * @param   port            Port on which output is emitted.
 * @param   msgInfo         Message to be emitted (ownership is transferred). 
 * @return                  Operation status.
 */
kFsFx(kStatus) kPxIoBlock_EmitOutput(kPxIoBlock block, kPxPort port, kMsgInfo msgInfo);

#include <kFireSync/Pipe/kPxIoBlock.x.h>

#endif
