/** 
 * @file    kHxTestJig.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_TEST_JIG_X_H
#define K_FIRESYNC_HX_TEST_JIG_X_H

#define kHX_TEST_JIG_DEFAULT_SIMULATION_PERIOD              (1000000)             //Default period (fs ns). 


typedef struct kHxTestJigVTable
{
    kObjectVTable base; 

    kStatus (kCall* VCommand)(kHxTestJig test, kTestJigCommand command, k64u data);
    kStatus (kCall* VStats)(kHxTestJig test, kTestJigStats* stats);
    kStatus (kCall* VClear)(kHxTestJig test);

} kHxTestJigVTable;

typedef struct kHxTestJigClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                           //Parent.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kTestJigModel model;                    //Test jig model. 

} kHxTestJigClass;

kDeclareVirtualClassEx(kFs, kHxTestJig, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxTestJig_Init(kHxTestJig test, kType type, kHxNode node, kAlloc alloc); 

kFsFx(kStatus) xkHxTestJig_VRelease(kHxTestJig test); 

kInlineFx(kStatus) xkHxTestJig_VCommand(kHxTestJig test, kTestJigCommand command, k64u data)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxTestJig_VStats(kHxTestJig test, kTestJigStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kInlineFx(kStatus) xkHxTestJig_VClear(kHxTestJig test)
{
    return kOK; 
}

#endif
