/** 
 * @file    kHxSerialOut.h
 * @brief   Declares the kHxSerialOut class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_SERIAL_OUT_H
#define K_FIRESYNC_HX_SERIAL_OUT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/kHxSerialOut.x.h>

/**
 * @class       kHxSerialOut
 * @extends     kObject
 * @ingroup     kFireSync-Hardware
 * @internal
 * @brief       Abstract base class for hardware serial output classes.
 */
//typedef kObject kHxSerialOut;      --forward-declared in kFsDef.x.h

kInlineFx(kHxNode) kHxSerialOut_Node(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->node;
}

kInlineFx(kSize) kHxSerialOut_Index(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->index;
}

kInlineFx(kStatus) kHxSerialOut_Enable(kHxSerialOut serial, kBool enabled)
{
    kObj(kHxSerialOut, serial); 

    obj->enabled = enabled; 

    return kOK; 
}

kInlineFx(kBool) kHxSerialOut_IsEnabled(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->enabled; 
}

kInlineFx(kStatus) kHxSerialOut_SetControl(kHxSerialOut serial, kSerialOutControl type)
{
    kObj(kHxSerialOut, serial); 

    obj->controlType = type; 

    return kOK; 
}

kInlineFx(kSerialOutControl) kHxSerialOut_Control(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->controlType; 
}

kInlineFx(kStatus) kHxSerialOut_SetControlId(kHxSerialOut serial, kSize id)
{
    kObj(kHxSerialOut, serial); 

    obj->controlId = id; 

    return kOK; 
}

kInlineFx(kSize) kHxSerialOut_ControlId(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->controlId; 
}

kInlineFx(kStatus) kHxSerialOut_SetMode(kHxSerialOut serial, kSerialOutMode mode)
{
    kObj(kHxSerialOut, serial); 

    obj->mode = mode;
    
    return kOK;
}

kInlineFx(kSerialOutMode) kHxSerialOut_Mode(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->mode; 
}

kInlineFx(kStatus) kHxSerialOut_SetBitRate(kHxSerialOut serial, k32u bitRate)
{
    kObj(kHxSerialOut, serial); 

    obj->bitRate = bitRate;
    
    return kOK;
}

kInlineFx(k32u) kHxSerialOut_BitRate(kHxSerialOut serial)
{
    kObj(kHxSerialOut, serial); 

    return obj->bitRate;
}

kInlineFx(kStatus) kHxSerialOut_Write(kHxSerialOut serial, const void* buffer, kSize size)
{
    return xkHxSerialOut_VTable(serial)->VWrite(serial, buffer, size);
}

kInlineFx(kStatus) kHxSerialOut_Stats(kHxSerialOut serial, kSerialOutStats* stats)
{
    return xkHxSerialOut_VTable(serial)->VStats(serial, stats);
}

kInlineFx(kStatus) kHxSerialOut_Clear(kHxSerialOut serial)
{
    return xkHxSerialOut_VTable(serial)->VClear(serial);
}

#endif
