/** 
 * @file    kHxNullNode.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_NULL_NODE_X_H
#define K_FIRESYNC_HX_NULL_NODE_X_H

#include <kFireSync/Hardware/kHxNode.h>

//health log definitions
#define kHX_NULL_NODE_HEALTH_LOG_SIZE_BYTES    (8*1024*1024)        ///< health log size, in megabytes

typedef struct kHxNullNodeClass
{
    kHxNodeClass base; 

    kHealth health;                     //health service, accepted in constructor
    kHealthLog healthLog;               //Health log instance.

    kBool hasDefaultNetConfig;          //is the node using its default network configuration?
    kBool globalLogEnabled;             //should node log be integrated with global log?
   
    kTempControlEx tempControl;         //supports set/get; no actual use; could potentially eliminate

} kHxNullNodeClass;

kDeclareClassEx(kFs, kHxNullNode, kHxNode) 


kFsFx(kStatus) xkHxNullNode_Init(kHxNullNode node, kType type, k32u nodeId, kHealth health, const kChar* storagePath, kAlloc alloc);
kFsFx(kStatus) xkHxNullNode_VRelease(kHxNullNode node);

kFsFx(kStatus) kHxNullNode_PrepareStorage(kHxNullNode node, const kChar* storagePath);

kFsFx(kHealth) xkHxNullNode_VHealth(kHxNullNode node);

kFsFx(kStatus) xkHxNullNode_AddNetInterface(kHxNullNode node, kNetworkInterface iface);

kFsFx(kStatus) xkHxNullNode_VDynamicIpConfig(kHxNullNode node, kSize index, kIpConfig* config);
kFsFx(kStatus) xkHxNullNode_VLogEx(kHxNullNode node, kLogOption options, const kChar* source, const kChar* message);

kFsFx(kStatus) xkHxNullNode_VStats(kHxNullNode node, kNodeStats* stats);

kFsFx(kStatus) xkHxNullNode_StartHealthLog(kHxNullNode node, kAlloc alloc);
kFsFx(kStatus) xkHxNullNode_StopHealthLog(kHxNullNode node);

//[Deprecated] Use kHxNullNode_AddNetInterfaceByNetwork instead.
kFsFx(kStatus) kHxNullNode_AddNetInterfaceBySubnet(kHxNullNode node, kIpAddress subnet, k32u prefixLength);

#endif
