/** 
 * @file    kHxAnalogOut.x.h
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_ANALOG_OUT_X_H
#define K_FIRESYNC_HX_ANALOG_OUT_X_H

typedef struct kHxAnalogOutVTable
{
    kObjectVTable base; 

    kStatus (kCall* VSetCalibration)(kHxAnalogOut analog, kArray2 calibration);
    k64f (kCall* VMinCurrent)(kHxAnalogOut analog); 
    k64f (kCall* VMaxCurrent)(kHxAnalogOut analog);
    kBool (kCall* VIsCalibrated)(kHxAnalogOut analog);
    kStatus (kCall* VEnqueueCurrent)(kHxAnalogOut analog, k64f current);
    kStatus (kCall* VEnqueueState)(kHxAnalogOut analog, k32u value);        //deprecated
    kStatus (kCall* VStats)(kHxAnalogOut analog, kAnalogOutStats* stats);
    kStatus (kCall* VClear)(kHxAnalogOut analog);

} kHxAnalogOutVTable;

typedef struct kHxAnalogOutClass
{
    kObjectClass base;  

    /* 
     * Read-only attributes established during init.
     */

    kHxNode node;                           //Parent.
    kSize index;                            //Index of this object in parent context.

    /* 
     * Read-only attributes that must be established by descendant during descendant init.
     */

    kAnalogOutModel model;                  //Logical DAC model. 

    /* 
     * Dynamic properties that can be re/initialized by calling Clear method from descendant. 
     */

    kBool enabled;                          //Is enabled setting.
    kAnalogOutControl controlType;          //Control mode setting.
    kSize controlId;                        //Control id setting.

} kHxAnalogOutClass;

kDeclareVirtualClassEx(kFs, kHxAnalogOut, kObject)

/*
* Protected 
*/

kFsFx(kStatus) xkHxAnalogOut_Init(kHxAnalogOut analog, kType type, kHxNode node, kSize index, kAlloc alloc); 

kFsFx(kStatus) xkHxAnalogOut_VRelease(kHxAnalogOut analog); 

kInlineFx(kStatus) xkHxAnalogOut_VSetCalibration(kHxAnalogOut analog, kArray2 calibration)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(k64f) xkHxAnalogOut_VMinCurrent(kHxAnalogOut analog)
{
    return 0;
}

kInlineFx(k64f) xkHxAnalogOut_VMaxCurrent(kHxAnalogOut analog)
{
    return 0;
}

kInlineFx(kBool) xkHxAnalogOut_VIsCalibrated(kHxAnalogOut analog)
{
    return kFALSE;
}

kInlineFx(kStatus) xkHxAnalogOut_VEnqueueCurrent(kHxAnalogOut analog, k64f current)
{
    return kERROR_UNIMPLEMENTED;
}

kInlineFx(kStatus) xkHxAnalogOut_VStats(kHxAnalogOut analog, kAnalogOutStats* stats)
{
    return kERROR_UNIMPLEMENTED;
}

//can optionally be overridden, but probably doesn't need to be
kFsFx(kStatus) xkHxAnalogOut_VClear(kHxAnalogOut analog);


//Deprecated, but retained for compatibility. Allows current output to be specified directly by DAC code. 
kInlineFx(kStatus) kHxAnalogOut_EnqueueState(kHxAnalogOut analog, k32u value)
{
    return xkHxAnalogOut_VTable(analog)->VEnqueueState(analog, value);
}

kInlineFx(kStatus) xkHxAnalogOut_VEnqueueState(kHxAnalogOut analog, k32u value)
{
    return kERROR_UNIMPLEMENTED;
}

#endif
