/** 
 * @file    kHxProjectorExt.h
 * @brief   Declares the kHxProjectorExt class.
 *
 * @internal
 * Copyright (C) 2018-2022 by LMI Technologies Inc. All rights reserved.
 */
#ifndef K_FIRESYNC_HX_PROJECTOR_EXT_H
#define K_FIRESYNC_HX_PROJECTOR_EXT_H

#include <kFireSync/kNodeDef.h>
#include <kFireSync/Hardware/Projector/kHxProjectorExt.x.h>

/**
 * @class       kHxProjectorExt
 * @extends     kObject
 * @ingroup     kFireSync-Hardware-Projector
 * @internal
 * @brief       Abstract base class for hardware projector extension classes.
 */
//typedef kObject kHxProjectorExt;      --forward-declared in kFsDef.x.h

kInlineFx(kProjectorExt) kHxProjectorExt_Config(kHxProjectorExt ext)
{
    kObj(kHxProjectorExt, ext); 

    return obj->config;
}

#endif
