/** 
 * @file    kTimeAvg.x.h
 *
 * @internal
 * Copyright (C) 2017-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TIME_AVG_X_H
#define K_FIRESYNC_TIME_AVG_X_H

#include <kApi/Data/kArray1.h>

#define kTIME_AVG_DEFAULT_CAPACITY              (16)            //default capacity, in entries.

typedef struct kTimeAvgEntry
{
    k64u time;                  //Sample time (microseconds).
    k64s value;                 //Sample value. 
} kTimeAvgEntry;

kDeclareValueEx(kFs, kTimeAvgEntry, kValue)

typedef struct kTimeAvgClass
{
    kObjectClass base; 
    k64u window;               //Window for time average, in microseconds.
    k64u minInterval;          //Minimum elasped time before a new sample should be accepted, in microseconds.
    k64s sum;                  //Sum of currently buffered samples. 
    kQueue samples;            //Data -- kQueue<kTimeAvgEntry>
} kTimeAvgClass; 

kDeclareClassEx(kFs, kTimeAvg, kObject)
        
kFsFx(kStatus) kTimeAvg_Init(kTimeAvg stat, kType type, k64u window, k64u minInterval, kAlloc alloc); 
kFsFx(kStatus) kTimeAvg_VRelease(kTimeAvg stat); 

#endif
