/** 
 * @file    kArchive.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ARCHIVE_X_H
#define K_FIRESYNC_ARCHIVE_X_H

#include <kApi/Data/kArrayList.h>
#include <kApi/Io/kPath.h>
#include <kApi/Io/kFile.h>
#include <kApi/Io/kSerializer.h>

#define kFS_ARCHIVE_SIGNATURE           (0x39281b0c)
#define kFS_ARCHIVE_VERSION             (1)
#define kFS_ARCHIVE_FILE_NAME_LENGTH    (512)

typedef struct kArchiveFileHeader 
{
    kChar fileName[kFS_ARCHIVE_FILE_NAME_LENGTH];
    k64u attributes;
    k64u time;
    k64u size;
    k64u offset;
} kArchiveFileHeader;

kDeclareValueEx(kFs, kArchiveFileHeader, kValue)

typedef struct kArchiveClass  
{
    kObjectClass base;

    // used in editing mode
    kArrayList      headers;
    kArrayList      fileData;

    // used in reading mode
    const void*     data;
    k64u            dataLength;

    kBool           editMode;
    k32u            crc;
} kArchiveClass;

kDeclareClassEx(kFs, kArchive, kObject)

kFsFx(kStatus) kArchive_Init(kArchive archive, kType type, kAlloc alloc);
kFsFx(kStatus) kArchive_VRelease(kArchive archive);

kFsFx(kArchiveFileHeader*) kArchive_FileHeader(kArchive archive, kSize index);
kFsFx(kStatus) kArchive_Write32u(kStream stream, k32u value);
kFsFx(kStatus) kArchive_Read32u(kStream stream, k32u *value);
kFsFx(kStatus) kArchive_CombinePath(const kChar *path1, const kChar *path2, kChar **path);
kFsFx(kStatus) kArchive_WriteFile(kArchive archive, const void *data, k32u length, const kChar *path);

#endif
