/** 
 * @file    kTestJig.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_TEST_JIG_X_H
#define K_FIRESYNC_TEST_JIG_X_H

typedef struct kTestJigClass
{
    kObjectClass base; 
    kNode node; 
    kTestJigModel model;
} kTestJigClass; 

kDeclareClassEx(kFs, kTestJig, kObject)
        
kFsFx(kStatus) kTestJig_Construct(kTestJig* test, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kTestJig_Init(kTestJig test, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kTestJig_VRelease(kTestJig test); 

kFsFx(kStatus) kTestJig_Parse(kTestJig test, kXml xml, kXmlItem item); 
kFsFx(kStatus) kTestJig_Format(kTestJig test, kXml xml, kXmlItem item); 

kFsFx(kStatus) kTestJig_VerificationLabel(kTestJig test, kChar* label, kSize capacity); 
kFsFx(kStatus) kTestJig_Verify(kTestJig test); 

kFsFx(kStatus) kTestJig_ClearEx(kTestJig test, kNodeClearOption options);

#endif
