/** 
 * @file    kTempControl.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_TEMP_X_H
#define K_FIRESYNC_LIGHT_TEMP_X_H

#define kTEMP_CONTROL_SETPOINT                      (25.0)
#define kTEMP_CONTROL_SETPOINT_MIN                  (-10.0)
#define kTEMP_CONTROL_SETPOINT_MAX                  (40.0)

#define kTEMP_CONTROL_DT                            (0.5)
#define kTEMP_CONTROL_DT_MIN                        (0.1)
#define kTEMP_CONTROL_DT_MAX                        (10.0)

#define kTEMP_CONTROL_KP                            (-20.0)
#define kTEMP_CONTROL_KP_MIN                        (-256.0)
#define kTEMP_CONTROL_KP_MAX                        (256.00)

#define kTEMP_CONTROL_KI                            (-0.5)
#define kTEMP_CONTROL_KI_MIN                        (-10.0)
#define kTEMP_CONTROL_KI_MAX                        (10.0)

#define kTEMP_CONTROL_KD                            (0.0)
#define kTEMP_CONTROL_KD_MIN                        (k32S_MIN)
#define kTEMP_CONTROL_KD_MAX                        (k32S_MAX)

#define kTEMP_CONTROL_KS                            (128.0)
#define kTEMP_CONTROL_KS_MIN                        (0.0)
#define kTEMP_CONTROL_KS_MAX                        (255.0)

#define kTEMP_CONTROL_SAFETY_MIN                    (18.0)
#define kTEMP_CONTROL_SAFETY_MIN_MIN                (0.0)
#define kTEMP_CONTROL_SAFETY_MIN_MAX                (255.0)

#define kTEMP_CONTROL_SAFETY_MAX                    (200.0)
#define kTEMP_CONTROL_SAFETY_MAX_MIN                (0.0)
#define kTEMP_CONTROL_SAFETY_MAX_MAX                (255.0)

#define kTEMP_CONTROL_SAFETY_INTEGRATOR_MAX         (60.0)
#define kTEMP_CONTROL_SAFETY_INTEGRATOR_MAX_MIN     (0.0)
#define kTEMP_CONTROL_SAFETY_INTEGRATOR_MAX_MAX     (360.0)

typedef struct kTempControlClass
{
    kObjectClass base; 

    kNode node;                         //Node (hierarchy ancestor).
    kTempControlEx tempControl;

} kTempControlClass; 

kDeclareClassEx(kFs, kTempControl, kObject)
        
kFsFx(kStatus) kTempControl_Construct(kTempControl* control, kNode node, kSize index, kAlloc allocator); 

kFsFx(kStatus) kTempControl_Init(kTempControl control, kType type, kNode node, kAlloc alloc); 
kFsFx(kStatus) kTempControl_VRelease(kTempControl control); 

kFsFx(kStatus) kTempControl_Parse(kTempControl control, kXml xml, kXmlItem item); 
kFsFx(kStatus) kTempControl_Format(kTempControl control, kXml xml, kXmlItem item); 

kFsFx(kStatus) kTempControl_Verify(kTempControl control); 

kFsFx(kStatus) kTempControl_ClearEx(kTempControl control, kNodeClearOption options);

#endif
