/** 
 * @file    kPort.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PORT_X_H
#define K_FIRESYNC_PORT_X_H

typedef struct kPortClass
{
    kObjectClass base; 

    kNode node;                 //Node (hierarchy ancestor). 
    kBlock block;               //Parent block. 

    k32u id;                    //Unique numeric identifier. 
    kText32 name;               //Descriptive name.
    kPortDirection direction;   //Directionality.

} kPortClass; 

kDeclareClassEx(kFs, kPort, kObject)
        
kFsFx(kStatus) kPort_Construct(kPort* port, kNode node, kBlock block, kAlloc allocator); 

kFsFx(kStatus) kPort_Init(kPort port, kType type, kNode node, kBlock block, kAlloc alloc); 
kFsFx(kStatus) kPort_VRelease(kPort port); 

kFsFx(kStatus) kPort_Parse(kPort port, kXml xml, kXmlItem item); 
kFsFx(kStatus) kPort_Format(kPort port, kXml xml, kXmlItem item); 

kFsFx(kStatus) kPort_SetName(kPort port, const kChar* name); 
kFsFx(kStatus) kPort_SetId(kPort port, k32u id); 
kFsFx(kStatus) kPort_SetDirection(kPort port, kPortDirection direction); 

kFsFx(kBlock) kPort_Block(kPort port); 

#endif
